<?php

require_once('Language.php');
require_once('en_gb.php');

class pt_pt extends en_gb
{
    public function __construct()
    {
        parent::__construct();
    }
    protected function _LoadDates()
    {
        $dates = parent::_LoadDates();

        // change defaults here
        $dates['general_date'] = 'd/m/Y';
        $dates['general_datetime'] = 'd/m/Y H:i:s';
        $dates['schedule_daily'] = 'l, d/m/Y';
        $dates['reservation_email'] = 'd/m/Y @ H:i (e)';
        $dates['res_popup'] = 'd/m/Y H:i';
        $dates['dashboard'] = 'l, d/m/Y H:i';
        $dates['period_time'] = "H:i";
        $dates['timepicker'] = 'H:i';
        $dates['general_date_js'] = "dd/mm/yy";
        $dates['short_datetime'] = 'j/n/y H:i';
        $dates['schedule_daily'] = 'l, d/m/Y';
        $dates['res_popup_time'] = 'D, d/n H:i';
        $dates['short_reservation_date'] = 'j/n/y H:i';
        $dates['mobile_reservation_date'] = 'j/n H:i';
        $dates['general_time_js'] = 'H:mm';
        $dates['timepicker_js'] = 'H:i';
        $dates['momentjs_datetime'] = 'D/M/YY H:mm';
        $dates['calendar_time'] = 'H:mm';
        $dates['calendar_dates'] = 'd M';
        $dates['embedded_date'] = 'D d';
        $dates['embedded_time'] = 'H:i';
        $dates['embedded_datetime'] = 'd/m/Y H:i';
        $dates['report_date'] = '%m/%d';

        $this->Dates = $dates;
        return $this->Dates;
    }
    /**
     * @return array
     */
    protected function _LoadStrings()
    {
        $strings = parent::_LoadStrings();

        $strings['About'] = 'Sobre';
        $strings['Accept'] = 'Aceitar';
        $strings['Access'] = 'Acesso';
        $strings['Accessories'] = 'Acessórios';
        $strings['Accessory'] = 'Acessório';
        $strings['AccessoryMaxQuantityErrorMessage'] = 'Não pode reservar mais de %1$s do acessório %2$s';
        $strings['AccessoryMinQuantityErrorMessage'] = 'Deve reservar pelo menos %1$s do acessório %2$s';
        $strings['AccessoryName'] = 'Nome do acessório';
        $strings['AccessoryResourceAssociationErrorMessage'] = 'O acessório \'%s\' não pode ser reservado com os recursos solicitados';
        $strings['AccessoryResourceRequiredErrorMessage'] = 'O acessório %1$s só pode ser reservado com recursos %2$s';
        $strings['Account'] = 'Conta';
        $strings['AccountActivation'] = 'Ativação da Conta';
        $strings['AccountActivationError'] = 'Desculpe, não foi possível ativar a sua conta.';
        $strings['AccountCreatedSubject'] = 'Detalhes da sua conta %s';
        $strings['Actions'] = 'Ações';
        $strings['ActivateYourAccount'] = 'Por favor ative a sua conta';
        $strings['ActivationEmailSent'] = 'Irá receber um e-mail de ativação em breve.';
        $strings['Active'] = 'Ativo';
        $strings['AdHocMeeting'] = 'Reunião ad hoc';
        $strings['Add'] = 'Adicionar';
        $strings['AddAccessories'] = 'Adicionar acessórios';
        $strings['AddAccessory'] = 'Adicionar acessório';
        $strings['AddAnnouncement'] = 'Adicionar anúncio';
        $strings['AddAttribute'] = 'Adicionar um atributo';
        $strings['AddBlackout'] = 'Adicionar horário indisponível';
        $strings['AddGroup'] = 'Adicionar grupo';
        $strings['AddImage'] = 'Adicionar imagem';
        $strings['AddNewGroup'] = 'Adicionar um novo grupo';
        $strings['AddNewResource'] = 'Adicionar novo recurso';
        $strings['AddNewUser'] = 'Adicionar novo utilizador';
        $strings['AddParticipants'] = 'Adicionar participantes';
        $strings['AddQuota'] = 'Adicionar quota';
        $strings['AddReminder'] = 'Adicionar lembrete';
        $strings['AddReservationColorRule'] = 'Adicionar regra de cor de reserva';
        $strings['AddResource'] = 'Adicionar recurso';
        $strings['AddResourceType'] = 'Adicionar tipo de recurso';
        $strings['AddResources'] = 'Adicionar recursos';
        $strings['AddRule'] = 'Adicionar regra';
        $strings['AddSchedule'] = 'Adicionar agenda';
        $strings['AddToGoogleCalendar'] = 'Adicionar ao Google Calendar';
        $strings['AddToOutlook'] = 'Adicionar ao calendário';
        $strings['AddUser'] = 'Adicionar utilizador';
        $strings['AddingToWaitlist'] = 'Adicionando-o à lista de espera';
        $strings['AdditionalAttributes'] = 'Atributos adicionais';
        $strings['AdditionalInformation'] = 'Informações adicionais';
        $strings['AdminOnly'] = 'É apenas para administradores';
        $strings['Administration'] = 'Administração';
        $strings['AdvancedFilter'] = 'Filtro avançado';
        $strings['AggregateBy'] = 'Agregar por';
        $strings['All'] = 'Tudo';
        $strings['AllAccessories'] = 'Todos os acessórios';
        $strings['AllDay'] = 'Dia inteiro';
        $strings['AllFieldsAreRequired'] = 'todos os campos são obrigatórios';
        $strings['AllGroups'] = 'Todos os grupos';
        $strings['AllInstances'] = 'Todas as instâncias';
        $strings['AllNoUpcomingReservations'] = 'Não existem reservas futuras nos próximos %s dias';
        $strings['AllParticipants'] = 'Todos os participantes';
        $strings['AllQuotas'] = 'Todas as quotas';
        $strings['AllReservationResources'] = 'Todos os recursos da reserva';
        $strings['AllReservations'] = 'Todas as reservas';
        $strings['AllResourceStatuses'] = 'Todos os estados de recursos';
        $strings['AllResourceTypes'] = 'Todos os tipos de recursos';
        $strings['AllResources'] = 'Todos os recursos';
        $strings['AllResourcesOn'] = 'Todos recursos em';
        $strings['AllSchedules'] = 'Todas as agendas';
        $strings['AllTime'] = 'Todos os tempos';
        $strings['AllUpcomingReservations'] = 'Todas as reservas futuras';
        $strings['AllUsers'] = 'Todos os utilizadores';
        $strings['AllYear'] = 'Ano inteiro';
        $strings['AllowParticipantsToJoin'] = 'Permitir aos participantes participarem';
        $strings['AmountRefunded'] = 'Reembolsado';
        $strings['Announcement'] = 'Anúncio';
        $strings['AnnouncementEmailNotice'] = 'os utilizadores receberão este anúncio como um email';
        $strings['AnnouncementSubject'] = 'Um novo anúncio foi publicado por %s';
        $strings['Announcements'] = 'Anúncios';
        $strings['AnyResource'] = 'Qualquer recurso';
        $strings['AppearsOn'] = 'Aparece em %s';
        $strings['ApplicationManagement'] = 'Gestão da Aplicação';
        $strings['AppliesTo'] = 'Aplica-se a';
        $strings['ApplyToCurrentUsers'] = 'Aplicar aos utilizadores atuais';
        $strings['ApplyUpdatesTo'] = 'Aplicar atualizações para';
        $strings['Approve'] = 'Aprovar';
        $strings['Approving'] = 'Aprovar';
        $strings['AtomFeedTitle'] = '%s reservas';
        $strings['AttachFile'] = 'Anexar arquivo';
        $strings['AttachmentLoadingError'] = 'Desculpe, houve um problema ao carregar o arquivo solicitado.';
        $strings['Attachments'] = 'Anexos';
        $strings['Attending'] = 'Atender';
        $strings['Attribute'] = 'Atributo';
        $strings['Attributes'] = 'Atributos';
        $strings['AutoReleaseMinutes'] = 'Minutos para libertação automática';
        $strings['AutoReleaseNotification'] = 'Libertado automaticamente se não for efetuado o check-in dentro de %s minutes';
        $strings['Autofill'] = 'Preenchimento automático';
        $strings['AutomaticallyAddToGroup'] = 'Adicionar automaticamente novos utilizadores a este grupo';
        $strings['Availability'] = 'Disponibilidade';
        $strings['Available'] = 'Disponível';
        $strings['AvailableAllYear'] = 'Ano inteiro';
        $strings['AvailableAt'] = 'Disponível em';
        $strings['AvailableBeginningAt'] = 'Disponível a partir de';
        $strings['AvailableBetween'] = 'Disponível entre';
        $strings['AvailableCredits'] = 'Créditos disponiveis';
        $strings['AvailableUntil'] = 'Disponível até';
        $strings['AwaitingActivation'] = 'Aguardando Ativação';
        $strings['Back'] = 'Voltar';
        $strings['BackToCalendar'] = 'Voltar ao calendário';
        $strings['BeginDate'] = 'Início';
        $strings['Between'] = 'Entre';
        $strings['BlackoutAroundConflicts'] = 'Horário indisponível em torno de reservas em conflito';
        $strings['BlackoutConflicts'] = 'Existem horários indisponíveis em conflito';
        $strings['BlackoutCreated'] = 'Horário indisponível criado!';
        $strings['BlackoutDeleteConflicts'] = 'Excluir reservas em conflito';
        $strings['BlackoutNotCreated'] = 'Horário indisponível não pôde ser criado!';
        $strings['BlackoutNotUpdated'] = 'Horário de indisponibilidade não pode ser atualizado';
        $strings['BlackoutShowMe'] = 'Mostrar reservas em conflito';
        $strings['BlackoutUpdated'] = 'Horário indisponível atualizado';
        $strings['BlackoutsWillBeDeleted'] = 'os horários indisponíveis serão apagados';
        $strings['BlockedTimeSlots'] = 'Intervalos de horários bloqueados';
        $strings['Bookings'] = 'Reservas';
        $strings['BringDown'] = 'Mover para baixo';
        $strings['BringOnline'] = 'Colocar Online';
        $strings['Browse'] = 'Navegar';
        $strings['BulkResourceDelete'] = 'Exclusão em massa de recursos';
        $strings['BulkResourceUpdate'] = 'Atualização em massa de recursos';
        $strings['BuyCredits'] = 'Comprar créditos';
        $strings['BuyMoreCredits'] = 'Comprar mais créditos';
        $strings['Cancel'] = 'Cancelar';
        $strings['CancelParticipation'] = 'Cancelar participação';
        $strings['Capacity'] = 'Capacidade';
        $strings['CaptchaMustMatch'] = 'Por favor digite as letras da imagem de segurança exatamente como mostrado.';
        $strings['Category'] = 'Categoria';
        $strings['CategoryGroup'] = 'Grupo';
        $strings['CategoryReservation'] = 'Reservar';
        $strings['Change'] = 'Alterar';
        $strings['ChangeCalendar'] = 'Alterar calendário';
        $strings['ChangeConfiguration'] = 'Alterar configuração';
        $strings['ChangeLanguage'] = 'Alterar idioma';
        $strings['ChangeLayout'] = 'Mudar disposição';
        $strings['ChangePassword'] = 'Alterar Senha';
        $strings['ChangeUser'] = 'Alterar utilizador';
        $strings['CheckIn'] = 'Check-in';
        $strings['CheckInFailed'] = 'Não foi possível fazer o check-in';
        $strings['CheckInTime'] = 'Hora de check-in';
        $strings['CheckOut'] = 'Check-out';
        $strings['CheckOutFailed'] = 'Não foi possível fazer o check-out';
        $strings['CheckOutTime'] = 'Hora de check--out';
        $strings['Checkbox'] = 'Caixa de seleção';
        $strings['CheckedInSuccess'] = 'Efetuou o check-in';
        $strings['CheckedOutSuccess'] = 'Efetuou o check-out';
        $strings['CheckingAvailability'] = 'Verificando disponibilidade';
        $strings['CheckingIn'] = 'Efetuando o check-in';
        $strings['CheckingOut'] = 'Efetuando o check-out';
        $strings['Checkout'] = 'Check-out';
        $strings['CheckResources'] = 'Consultar Recursos';
        $strings['CheckSchedules'] = 'Consultar Horários';
        $strings['Choose'] = 'Escolher';
        $strings['ChooseOrDropFile'] = 'Escolha um ficheiro ou arraste-o para aqui';
        $strings['ClearFilter'] = 'Limpar filtro';
        $strings['Close'] = 'Fechar';
        $strings['CollectFor'] = 'Recolher para';
        $strings['CollectedFor'] = 'Recolhido para';
        $strings['Color'] = 'Cor';
        $strings['Columns'] = 'Colunas';
        $strings['CommaSeparated'] = 'separados por vírgula';
        $strings['Common'] = 'Comum';
        $strings['CommonReports'] = 'Relatórios comuns';
        $strings['ConcurrentNo'] = 'Os recursos não podem ser reservados por mais de uma pessoa de cada vez ';
        $strings['ConcurrentYes'] = 'Os recursos podem ser reservados por mais de uma pessoa de cada vez';
        $strings['CondensedWeekScheduleDisplay'] = 'Utilize a exibição de agenda semanal condensada';
        $strings['ConfigUpdateFailure'] = 'Não foi possível atualizar automaticamente o seu ficheiro de configuração. Por favor, substitua o conteúdo do config.php pelo seguinte:';
        $strings['ConfigUpdateSuccess'] = 'O seu ficheiro de configuração está, agora, atualizado!';
        $strings['ConfigurationFileNotWritable'] = 'Não possível gravar o ficheiro de configuração. Por favor verifique as permissões deste ficheiro e tente novamente.';
        $strings['ConfigurationUpdateHelp'] = 'Consulte a secção de Configuração no <a target=_blank href=%s>Ficheiro de Ajuda</a> para documentação sobre estas configurações.';
        $strings['ConfigurationUpdated'] = 'O ficheiro de configuração foi atualizado';
        $strings['ConfigureApplication'] = 'Configure o LibreBooking';
        $strings['ConflictingAccessoryDates'] = 'Não são suficientes os seguintes acessórios:';
        $strings['ConflictingReservationDates'] = 'Há reservas em conflito nas seguintes datas:';
        $strings['Contact'] = 'Contato';
        $strings['Continue'] = 'Continuar';
        $strings['Copy'] = 'Copiar';
        $strings['Cost'] = 'Custo';
        $strings['Count'] = 'Contagem';
        $strings['Create'] = 'Criar';
        $strings['CreateAnAccount'] = 'Criar conta';
        $strings['CreateDatabase'] = 'Criar a base de dados';
        $strings['CreateDatabaseUser'] = 'Criar o utilizador da base de dados';
        $strings['CreateReservation'] = 'Criar Reservas';
        $strings['CreateReservationHeading'] = 'Criar uma nova reserva';
        $strings['Created'] = 'Criado';
        $strings['CreatedBy'] = 'Criado por';
        $strings['CreatingReservation'] = 'Criação de reserva';
        $strings['CreditHistory'] = 'Histórico de crédito';
        $strings['CreditPurchase'] = 'Compra de crédito';
        $strings['CreditPurchaseNotEnabled'] = 'Não ativou a opção de comprar créditos';
        $strings['CreditUsagePerSlot'] = 'Requer %s créditos por intervalo (fora de pico)';
        $strings['Credits'] = 'Créditos';
        $strings['CreditsAfter'] = 'Créditos depois';
        $strings['CreditsBefore'] = 'Créditos antes';
        $strings['CreditsCost'] = 'Cada crédito custa';
        $strings['CreditsOffPeak'] = 'Créditos (fora do pico)';
        $strings['CreditsPeak'] = 'Créditos (pico)';
        $strings['CreditsPurchased'] = 'créditos adquiridos.';
        $strings['CreditsRequired'] = 'Créditos necessários';
        $strings['CreditsRule'] = 'Não tem créditos suficientes. Créditos necessários: %1$s. Créditos em conta: %2$s';
        $strings['CreditsUpdated'] = 'O custo do crédito foi atualizado';
        $strings['CreditsUpdatedLog'] = 'Créditos atualizados por %s';
        $strings['CssFile'] = 'Ficheiro CSS';
        $strings['Currency'] = 'Moeda';
        $strings['CurrentMonth'] = 'Mês atual';
        $strings['CurrentPassword'] = 'Senha atual';
        $strings['CurrentStatus'] = 'Estado atual';
        $strings['CurrentWeek'] = 'Semana atual';
        $strings['CustomAttributeErrors'] = 'Há problemas com os atributos adicionais que forneceu:';
        $strings['CustomAttributeInvalid'] = "O valor fornecido para %s é inválido\n";
        $strings['CustomAttributeRequired'] = "%s é um campo obrigatório\n";
        $strings['CustomAttributes'] = 'Atributos personalizados';
        $strings['Customization'] = 'Personalização';
        $strings['Daily'] = 'Diário';
        $strings['Dashboard'] = 'Painel de Controlo';
        $strings['DataCleanup'] = 'Limpeza de dados';
        $strings['DataWipeWarning'] = 'Aviso: Isto eliminará todos os dados existentes';
        $strings['DatabaseCredentials'] = 'Deve fornecer credenciais de um utilizador MySQL que tenha privilégios para criar bases de dados. Se não souber, entre em contato com o administrador da base de dados. Em muitos casos, o root irá funcionar.';
        $strings['DatabaseHost'] = 'Hospedeiro da base de dados';
        $strings['DatabaseName'] = 'Nome da base de dados';
        $strings['DatabaseUser'] = 'Utilizador da base de dados';
        $strings['Date'] = 'Data';
        $strings['DateRange'] = 'Período';
        $strings['DateTime'] = 'Data e hora';
        $strings['Dates'] = 'Datas';
        $strings['Day'] = 'Dia';
        $strings['DayFridayAbbr'] = 'Sex';
        $strings['DayFridaySingle'] = 'S';
        $strings['DayMondayAbbr'] = 'Seg';
        $strings['DayMondaySingle'] = 'S';
        $strings['DaySaturdayAbbr'] = 'Sáb';
        $strings['DaySaturdaySingle'] = 'S';
        $strings['DaySundayAbbr'] = 'Dom';
        $strings['DaySundaySingle'] = 'D';
        $strings['DayThursdayAbbr'] = 'Qui';
        $strings['DayThursdaySingle'] = 'Q';
        $strings['DayTuesdayAbbr'] = 'Ter';
        $strings['DayTuesdaySingle'] = 'T';
        $strings['DayWednesdayAbbr'] = 'Qua';
        $strings['DayWednesdaySingle'] = 'Q';
        $strings['Decline'] = 'Recusar';
        $strings['DefaultPage'] = 'Página Inicial - Padrão';
        $strings['DefaultScheduleCannotBeDeleted'] = 'Agenda padrão não pode ser apagada';
        $strings['DefaultScheduleSet'] = 'Esta é agora a sua agenda padrão';
        $strings['DefaultStyle'] = 'Estilo padrão';
        $strings['Delete'] = 'Apagar';
        $strings['DeleteAccessoryWarning'] = 'Apagar este acessório irá removê-lo de todas as reservas.';
        $strings['DeleteBlackoutsBefore'] = 'Apagar horários indisponíveis antes de';
        $strings['DeleteGroupWarning'] = 'Apagar este grupo irá remover todas as permissões de recursos associados. Os utilizadores deste grupo podem perder o acesso aos recursos.';
        $strings['DeleteMultipleReservationsWarning'] = 'Não serão enviados emails.';
        $strings['DeleteMultipleUserWarning'] = 'A remoção destes utilizadores removerá todas as suas reservas atuais, futuras e antigas. Não será enviado nenhum email.';
        $strings['DeleteReminderWarning'] = 'Tem certeza de que deseja excluir este?';
        $strings['DeleteReservationsBefore'] = 'Apagar reservas antes de';
        $strings['DeleteResourceWarning'] = 'Apagar este recurso irá apagar todos os dados associados, incluindo';
        $strings['DeleteResourceWarningPermissions'] = 'todas as atribuições de permissão';
        $strings['DeleteResourceWarningReassign'] = 'Por favor, reatribuir qualquer coisa que não queira que seja eliminado antes de prosseguir';
        $strings['DeleteResourceWarningReservations'] = 'todas as reservas passadas, atuais e futuras associados';
        $strings['DeleteThisTimeSlot'] = 'Excluir este intervalo de horário?';
        $strings['DeleteUserWarning'] = 'Apagar este utilizador irá remover todas as suas reservas atuais, futuras e históricas.';
        $strings['DeleteWarning'] = 'Esta ação é permanente e irrecuperável!';
        $strings['Deleted'] = 'Removida';
        $strings['DeletedReservations'] = 'Reservas apagadas';
        $strings['Description'] = 'Descrição';
        $strings['DescriptionRequiredRule'] = 'A descrição da reserva é obrigatória';
        $strings['Detect'] = 'Detectar';
        $strings['DisplayLabel'] = 'Mostrar rótulo';
        $strings['DisplayPage'] = 'Exibir página';
        $strings['DoesNotRepeat'] = 'Não repetir';
        $strings['Done'] = 'Concluído';
        $strings['DuplicateReservation'] = 'Duplicada';
        $strings['Duration'] = 'Duração';
        $strings['EachCreditCosts'] = 'Cada crédito custa';
        $strings['Edit'] = 'Editar';
        $strings['EditAttribute'] = 'Atualizar um atributo';
        $strings['EditProfile'] = 'Editar o Meu Perfil';
        $strings['EditReservation'] = 'Editar Reservas';
        $strings['EditReservationHeading'] = 'Edição de reserva %s';
        $strings['Email'] = 'E-mail';
        $strings['EmailAddress'] = 'Endereço de e-mail';
        $strings['EmailDisabled'] = 'O administrador desabilitou as notificações de e-mail';
        $strings['EmailReport'] = 'Enviar relatório por email';
        $strings['EmailReservation'] = 'Enviar reserva por email';
        $strings['EmailTemplate'] = 'Modelo de email';
        $strings['EmptyCart'] = 'O seu carrinho está vazio.';
        $strings['EndDate'] = 'Final';
        $strings['EndTime'] = 'Hora de fim';
        $strings['EnterTermsManually'] = 'Introduzir termos manualmente';
        $strings['Error'] = 'Erro';
        $strings['ErrorCode'] = 'Código de erro:';
        $strings['ErrorMovingReservation'] = 'Erro ao mover a reserva';
        $strings['ErrorText'] = 'Texto de erro:';
        $strings['Everyday'] = 'Todos os dias';
        $strings['Executing'] = 'A realizar';
        $strings['Export'] = 'Exportar';
        $strings['ExportResources'] = 'Exportar recursos';
        $strings['ExportToCSV'] = 'Exportar para CSV';
        $strings['False'] = 'Falso';
        $strings['File'] = 'Ficheiro';
        $strings['Filter'] = 'Filtro';
        $strings['FilterBy'] = 'Filtrar por';
        $strings['FindATime'] = 'Encontrar horário';
        $strings['FindAnOpening'] = 'Encontrar Uma Abertura';
        $strings['FindGroup'] = 'Encontrar grupo';
        $strings['FindUser'] = 'Encontrar utilizador';
        $strings['FirstName'] = 'Nome';
        $strings['FirstNameRequired'] = 'O nome é obrigatório.';
        $strings['FirstTimeUser?'] = 'É a sua primeira visita?';
        $strings['FlipSchedule'] = 'Virar a disposição da agenda';
        $strings['ForgotMyPassword'] = 'Esqueci-me da minha senha';
        $strings['ForgotPassword'] = 'Esqueceu-se da sua Senha';
        $strings['ForgotPasswordEmailSent'] = 'Um e-mail foi enviado para o endereço fornecido com instruções para redefinir a sua senha';
        $strings['Format'] = 'Formato';
        $strings['Forward'] = 'Avançar';
        $strings['FullAccess'] = 'Acesso total';
        $strings['FullyRefunded'] = 'Reembolsado na totalidade';
        $strings['FutureInstances'] = 'Instâncias futuras';
        $strings['Gateway'] = 'Gateway';
        $strings['GatewayTransactionDate'] = 'Data da transação do gateway';
        $strings['GatewaysUpdated'] = 'As gateways de pagamento foram atualizadas';
        $strings['GeneralConfigSettings'] = 'configurações';
        $strings['GenerateReport'] = 'Criar novo relatório';
        $strings['GetReport'] = 'Obter relatório';
        $strings['GetTemplate'] = 'Obter modelo';
        $strings['Grid'] = 'Grelha';
        $strings['Group'] = 'Grupo';
        $strings['GroupAdmin'] = 'Administrador do grupo';
        $strings['GroupAutomaticallyAdd'] = 'Adicionar automáticamente';
        $strings['GroupMembers'] = 'Membros do grupo';
        $strings['GroupName'] = 'Nome do grupo';
        $strings['GroupReservations'] = 'Reservas para Grupos';
        $strings['GroupRoles'] = 'Regras do grupo';
        $strings['Groups'] = 'Grupos';
        $strings['Guest'] = 'Convidado';
        $strings['GuestAccountCreatedSubject'] = 'Detalhes da sua conta %s';
        $strings['Help'] = 'Ajuda';
        $strings['Hidden'] = 'Escondido';
        $strings['Hours'] = 'Horas';
        $strings['IAccept'] = 'Aceito';
        $strings['IcsLocationsAsResources'] = 'Os locais serão importados como recursos.';
        $strings['IcsMissingOrganizer'] = 'Qualquer evento sem um organizador terá o proprietário definido para o utilizador atual.';
        $strings['IcsWarning'] = 'As regras de reservas não serão aplicadas - conflitos, duplicados etc. são possíveis.';
        $strings['Image'] = 'Imagem';
        $strings['Import'] = 'Importar';
        $strings['ImportICS'] = 'Importar de ICS';
        $strings['ImportQuartzy'] = 'Importar do Quartzy';
        $strings['ImportResources'] = 'Importar recursos';
        $strings['Inactive'] = 'Inativo';
        $strings['IncludeDeleted'] = 'Incluir reservas removidas';
        $strings['IncludingCompletedReservations'] = 'Incluindo reservas concluídas';
        $strings['IncorrectInstallPassword'] = 'A senha introduzida estava incorreta';
        $strings['Install'] = 'Instalação';
        $strings['InstallApplication'] = 'Instalar o LibreBooking';
        $strings['InstallOptionsWarning'] = 'As opções seguintes provavelmente não funcionarão num ambiente hospedado. Se estiver a instalar num ambiente hospedado, utilizeas ferramentas do assistente MySQL para concluir estas etapas.';
        $strings['InstallPasswordInstructions'] = 'Em %1$s por favor defina %2$s para uma senha aleatória e difícil de adivinhar, depois regresse a esta página.<br/>Pode utilizar %3$s';
        $strings['InstallPasswordLocation'] = 'Esta pode ser encontrada em %1$s em %2$s.';
        $strings['InstallUpgradeConfig'] = 'É recomendável atualizar o seu ficheiro de configuração';
        $strings['InstallationFailure'] = 'Ocorreram problemas com a instalação. Por favor corrija-os e tente novamente a instalação.';
        $strings['InstallationSuccess'] = 'Instalação concluída com sucesso!';
        $strings['InstalledVersion'] = 'Esta agora a correr a versão %s do LibreBooking';
        $strings['InsufficientPermissionsError'] = 'Não tem permissão para aceder a este recurso';
        $strings['InvalidAttachmentExtension'] = 'Só pode fazer upload de arquivos do tipo: %s';
        $strings['InvalidEmailDomain'] = 'O endereço de email não é de um domínio permitido';
        $strings['InvalidEndReminderTime'] = 'O horário final do lembrete não é válido.';
        $strings['InvalidEndSlot'] = 'A data e hora final solicitadas não são válidas.';
        $strings['InvalidPassword'] = 'Senha atual está incorreta';
        $strings['InvalidReservationData'] = 'Houve problemas com seu pedido de reserva.';
        $strings['InvalidStartReminderTime'] = 'O horário de início do lembrete não é válido.';
        $strings['InvalidStartSlot'] = 'A data e hora de início solicitadas não são válidas.';
        $strings['InvitationList'] = 'Convidados';
        $strings['InviteOthers'] = 'Convidar outros';
        $strings['InviteUserSubject'] = '%1$s convidou-o para participar %2$s';
        $strings['InviteUsers'] = 'Convidar utilizadores';
        $strings['InviteUsersLabel'] = 'Introduza os endereços de email das pessoas a convidar';
        $strings['InviteeAddedSubject'] = 'Convite de reserva';
        $strings['InviteeAddedSubjectWithResource'] = '%1$s convidou-o para uma reserva para %2$s';
        $strings['InvoiceNumber'] = 'Número da fatura';
        $strings['IssueRefund'] = 'Emitir reembolso';
        $strings['Join'] = 'Participar';
        $strings['Language'] = 'Idioma';
        $strings['LastLogin'] = 'Último acesso';
        $strings['LastModified'] = 'Última modificação';
        $strings['LastName'] = 'Apelido';
        $strings['LastNameRequired'] = 'O apelido é obrigatório.';
        $strings['LaterThisWeek'] = 'Ainda esta semana';
        $strings['LayoutDescription'] = 'Inicia em %1$s, mostrando %2$s dias de uma só vez';
        $strings['LayoutInstructions'] = 'Introduza um intervalo por linha. Os intervalos devem ser fornecidos para todas as 24 horas do dia começando e terminando às 12:00.';
        $strings['LayoutVariesByDay'] = 'A disposição varia por dia';
        $strings['LimitAttributeScope'] = 'Recolher em casos específicos';
        $strings['LinkToTerms'] = 'Hiperligação para os Termos de serviço';
        $strings['List'] = 'Lista';
        $strings['Live'] = 'Ativo';
        $strings['Location'] = 'Local';
        $strings['LogIn'] = 'Entrar';
        $strings['Login'] = 'Entrar';
        $strings['LoginError'] = 'Não foi possível encontrar seu utilizador ou senha';
        $strings['LoginWithSampleAccounts'] = 'Se importou os dados de amostra, pode agora entrar com admin/password para o administrador ou user/password para o utilizador básico.';
        $strings['Logo'] = 'Logo';
        $strings['LookAndFeel'] = 'Aparência';
        $strings['MakeDefault'] = 'Tornar padrão';
        $strings['MakeDefaultSchedule'] = 'Tornar esta a minha agenda padrão';
        $strings['Manage'] = 'Gerir';
        $strings['ManageAccessories'] = 'Acessórios';
        $strings['ManageAnnouncements'] = 'Anúncios';
        $strings['ManageBlackouts'] = 'Horários Indisponíveis';
        $strings['ManageConfiguration'] = 'Configuração da aplicação';
        $strings['ManageEmailTemplates'] = 'Gerir modelos de email';
        $strings['ManageGroups'] = 'Grupos';
        $strings['ManagePayments'] = 'Pagamentos';
        $strings['ManageQuotas'] = 'Quotas';
        $strings['ManageReminders'] = 'Lembretes';
        $strings['ManageReservations'] = 'Reservas';
        $strings['ManageResourceGroups'] = 'Grupos de recursos';
        $strings['ManageResourceStatus'] = 'Estados dos recursos';
        $strings['ManageResourceTypes'] = 'Tipos de recursos';
        $strings['ManageResources'] = 'Recursos';
        $strings['ManageSchedules'] = 'Agendas';
        $strings['ManageUsers'] = 'Utilizadores';
        $strings['MaxDurationError'] = 'Esta reserva não pode durar mais do que %s.';
        $strings['MaxNoticeError'] = 'Esta reserva não pode ser feita tão longe no futuro. A última data em que pode ser reservado é %s.';
        $strings['MaxParticipantsError'] = '%1$s apenas pode suportar %2$s participantes.';
        $strings['Maximum'] = 'máximo';
        $strings['MaximumQuantity'] = 'Quantidade máxima';
        $strings['Members'] = 'Membros';
        $strings['MinDurationError'] = 'Esta reserva deve durar pelo menos %s.';
        $strings['MinNoticeError'] = 'Esta reserva exige aviso prévio. A data mais próxima em que pode ser reservado é %s.';
        $strings['MinNoticeErrorDelete'] = 'A eliminação desta reserva requer aviso prévio. Reservas antes de %s não podem ser eliminadas.';
        $strings['MinNoticeErrorUpdate'] = 'Alterar esta reserva requer aviso prévio. As reservas anteriores a %s não podem ser alteradas.';
        $strings['MinimumCapacity'] = 'Capacidade mínima';
        $strings['MinimumQuantity'] = 'Quantidade mínima';
        $strings['Minutes'] = 'Minutos';
        $strings['MissedCheckin'] = 'Falhou o check-in';
        $strings['MissedCheckinEmailSubject'] = 'Check-in perdido para %s ';
        $strings['MissedCheckout'] = 'Falhou o check-out';
        $strings['MissingReservationResourceError'] = 'Um recurso não foi selecionado';
        $strings['MissingReservationScheduleError'] = 'A agenda não foi selecionada';
        $strings['Month'] = 'Mês';
        $strings['Monthly'] = 'Mensal';
        $strings['More'] = 'Mais';
        $strings['MoreOptions'] = 'Mais opções';
        $strings['MoreResources'] = 'Mais Recursos';
        $strings['Move'] = 'Mover';
        $strings['MoveResourcesAndReservations'] = 'Mover recursos e reservas para';
        $strings['MoveToSchedule'] = 'Mover para agenda';
        $strings['MultiDayRule'] = '%s não permite reservas através de dias.';
        $strings['MultiLineTextbox'] = 'Caixa de texto de várias linhas';
        $strings['MyAccount'] = 'A Minha Conta';
        $strings['MyCalendar'] = 'O Meu Calendário';
        $strings['MyDashboard'] = 'O Meu Painel de Controlo';
        $strings['MyReservation'] = 'As minhas reservas';
        $strings['MySQLUser'] = 'Nome de utilizador MySQL';
        $strings['MySavedReports'] = 'Os meus relatórios';
        $strings['Name'] = 'Nome';
        $strings['NameOrEmail'] = 'nome ou email';
        $strings['New'] = 'Novo';
        $strings['NewPassword'] = 'Nova senha';
        $strings['NewVersion'] = 'Nova versão!';
        $strings['Next'] = 'Seguinte';
        $strings['NextReservation'] = 'Próxima reserva';
        $strings['NextWeek'] = 'Próxima semana';
        $strings['No'] = 'Não';
        $strings['NoAnnouncements'] = 'Não há anúncios';
        $strings['NoAvailableMatchingTimes'] = 'Não há horários disponíveis que correspondam à sua pesquisa';
        $strings['NoCheckInRequiredNotification'] = 'Não requer check-in/out';
        $strings['NoContactLabel'] = '(nenhuma informação de contato)';
        $strings['NoDescriptionLabel'] = '(nenhuma descrição)';
        $strings['NoImage'] = 'Nenhuma imagem';
        $strings['NoLocationLabel'] = '(nenhum local definido)';
        $strings['NoNotesLabel'] = '(nenhuma nota)';
        $strings['NoReminders'] = 'Não tem lembretes futuros.';
        $strings['NoReservationAccess'] = 'Não tem permissão para alterar esta reserva.';
        $strings['NoReservationsFound'] = 'Não foram encontradas reservas';
        $strings['NoResourceAdministratorLabel'] = '(Nenhum administrador de recursos)';
        $strings['NoResourcePermission'] = 'Não tem permissão para aceder a um ou mais dos recursos solicitados';
        $strings['NoResourceTypeLabel'] = '(não foi definido um tipo de recurso)';
        $strings['NoResources'] = 'Não adicionou nenhum recurso.';
        $strings['NoResultsFound'] = 'Nenhum resultado correspondente encontrado';
        $strings['NoSavedReports'] = 'Não tem relatórios guardados';
        $strings['NoScheduleAdministratorLabel'] = 'Sem administrador de agenda';
        $strings['NoTitleLabel'] = '(nenhum título)';
        $strings['NoUpcomingReservations'] = 'Não tem reservas futuras';
        $strings['NoUpgradeNeeded'] = 'O LibreBooking está atualizado. Não há nenhuma atualização necessária.';
        $strings['None'] = 'Nenhum';
        $strings['NotAttending'] = 'Não comparecer';
        $strings['NotCountingCompletedReservations'] = 'Não incluindo reservas concluídas';
        $strings['NotSignedIn'] = 'Não está logado';
        $strings['Note'] = 'Nota';
        $strings['NoteCreditsPurchased'] = 'Créditos adquiridos';
        $strings['Notes'] = 'Notas';
        $strings['NotificationPreferences'] = 'Preferências de Notificação';
        $strings['NotifyUser'] = 'Notificar utilizador';
        $strings['NotifyWhenAvailable'] = 'Notificar-me quando disponível';
        $strings['NumberOfDaysVisible'] = 'Número de dias visíveis';
        $strings['OK'] = 'OK';
        $strings['OnlyIcs'] = 'Apenas ficheiros *.ics podem ser carregados.';
        $strings['OnlyViewedCalendar'] = 'Esta agenda apenas pode ser visualizada na vista do calendário';
        $strings['OpenInvitations'] = 'Abrir Convites';
        $strings['Optional'] = 'opcional';
        $strings['OptionalLabel'] = 'Título opcional';
        $strings['Organization'] = 'Organização';
        $strings['OriginalEndDate'] = 'Fim original';
        $strings['Page'] = 'Página';
        $strings['Participant'] = 'Participante';
        $strings['ParticipantAddedSubject'] = 'Notificação de participação na reserva';
        $strings['ParticipantAddedSubjectWithResource'] = '%1$s adicionou-o a uma reserva para %2$s';
        $strings['ParticipantUpdatedSubjectWithResource'] = '%s actualizou a reserva para %s';
        $strings['ParticipantDeletedSubject'] = 'Reserva removida';
        $strings['ParticipantDeletedSubjectWithResource'] = '%1$s removida uma reserva para %2$s';
        $strings['ParticipantList'] = 'Lista de participantes';
        $strings['Participants'] = 'Participantes';
        $strings['ParticipationNotAllowed'] = 'Não tem permissão para participar desta reserva.';
        $strings['Password'] = 'Senha';
        $strings['PasswordChangedSuccessfully'] = 'A sua senha foi alterada com sucesso';
        $strings['PasswordConfirmation'] = 'Confirmar senha';
        $strings['PasswordControlledExternallyError'] = 'A sua senha é controlada por um sistema externo e não pode ser atualizada aqui.';
        $strings['PasswordError'] = 'A senha deve conter pelo menos %1$s letras e pelo menos %2$s números.';
        $strings['PasswordErrorRequirements'] = 'A senha deve conter uma combinação de pelo menos %1$s letras maiúsculas e minúsculas e %2$s números.';
        $strings['Past'] = 'Passado';
        $strings['PayPalClientId'] = 'Client ID';
        $strings['PayPalEnvironment'] = 'Environment';
        $strings['PayPalSecret'] = 'Secret';
        $strings['PayWithCard'] = 'Pagar com cartão';
        $strings['PaymentGateways'] = 'Gateways de pagamento';
        $strings['PeakCreditUsagePerSlot'] = 'Requer %s créditos por intervalo (pico)';
        $strings['PeakTimes'] = 'Horários de pico';
        $strings['Pending'] = 'Pendente';
        $strings['PendingApproval'] = 'Aguardando Aprovação';
        $strings['PendingReservations'] = 'Reservas pendentes';
        $strings['PermanentlyDeleteUsers'] = 'Apagar permanentemente utilizadores que não entraram desde';
        $strings['Permissions'] = 'Permissões';
        $strings['Phone'] = 'Telefone';
        $strings['PopulateExampleData'] = 'Importar dados de amostra. Cria a conta de administrador: admin/password e a conta de utilizador: user/password';
        $strings['Position'] = 'Posição';
        $strings['PossibleValues'] = 'Valores possíveis';
        $strings['PreferenceNoEmail'] = 'Não me notificar';
        $strings['PreferenceSendEmail'] = 'Enviar um e-mail';
        $strings['Print'] = 'Imprimir';
        $strings['PrintQRCode'] = 'Imprimir código QR';
        $strings['Priority'] = 'Prioridade';
        $strings['Private'] = 'Privado';
        $strings['Profile'] = 'Perfil';
        $strings['ProvideInstallPassword'] = 'Por favor forneça sua senha de instalação.';
        $strings['Public'] = 'Público';
        $strings['PublicId'] = 'ID público';
        $strings['PurchaseFailed'] = 'Ocorreu um problema ao processar seu pagamento.';
        $strings['PurchaseSummary'] = 'Resumo da compra';
        $strings['Purge'] = 'Eliminar';
        $strings['PwMustMatch'] = 'A confirmação da senha deve coincidir com a senha.';
        $strings['Quantity'] = 'Quantidade';
        $strings['QuantityAvailable'] = 'Quantidade disponível';
        $strings['QuantityRequested'] = 'Quantidade solicitada';
        $strings['QuantityReserved'] = 'Quantidade reservada';
        $strings['QuickSlotCreation'] = 'Criar intervalos a cada %1$s minutos entre %2$s e %3$s';
        $strings['Quit'] = 'Sair';
        $strings['QuotaConfiguration'] = 'Em %1$s para %2$s utilizadores em %3$s estão limitados a %4$s %5$s por %6$s';
        $strings['QuotaEnforcement'] = 'Forçado %1$s %2$s';
        $strings['QuotaExceeded'] = 'Limite de quota excedido.';
        $strings['QuotaReminder'] = 'Lembre-se: As quotas são aplicadas com base no fuso horário da agenda.';
        $strings['Range'] = 'Alcance';
        $strings['Reason'] = 'Razão';
        $strings['ReasonText'] = 'Texto do motivo';
        $strings['ReferenceNumber'] = 'Número de referência';
        $strings['Refresh'] = 'Atualizar';
        $strings['Refund'] = 'Reembolso';
        $strings['RefundAmount'] = 'Montante de reembolso';
        $strings['RefundIssued'] = 'Reembolso emitido com sucesso';
        $strings['Register'] = 'Registar';
        $strings['RegisterANewAccount'] = 'Registar uma nova conta';
        $strings['RegisteredAccountRequired'] = 'Apenas utilizadores registados podem fazer reservas';
        $strings['Registration'] = 'Registo';
        $strings['Reject'] = 'Rejeitar';
        $strings['ReleasedIn'] = 'Libertado em';
        $strings['ReloadOriginalContents'] = 'Recarregar conteúdo original';
        $strings['RememberMe'] = 'Manter sessão iniciada';
        $strings['ReminderAddress'] = 'Endereços';
        $strings['ReminderBeforeEnd'] = 'antes da hora de fim';
        $strings['ReminderBeforeStart'] = 'antes da hora de início';
        $strings['ReminderMessage'] = 'Menssagem';
        $strings['ReminderRefNumber'] = 'Número de referência da reserva';
        $strings['ReminderSendtime'] = 'Hora para enviar';
        $strings['ReminderSendtimeAMPM'] = 'AM / PM';
        $strings['ReminderSendtimeDate'] = 'Data do lembrete';
        $strings['ReminderSendtimeTime'] = 'Hora do lembrete (HH:MM)';
        $strings['ReminderUser'] = 'ID de utilizador';
        $strings['Reminders'] = 'Lembretes';
        $strings['Remove'] = 'Remover';
        $strings['RemoveExistingPermissions'] = 'Remover permissões existentes?';
        $strings['Rename'] = 'Renomear';
        $strings['RepeatDaysPrompt'] = 'Em';
        $strings['RepeatEveryPrompt'] = 'Todo';
        $strings['RepeatPrompt'] = 'Repetir';
        $strings['RepeatUntilPrompt'] = 'Até';
        $strings['ReportSaved'] = 'Relatório guardado!';
        $strings['ReportSent'] = 'Relatório enviado!';
        $strings['ReportSubject'] = 'O relatório solicitado (%s)';
        $strings['Reports'] = 'Relatórios';
        $strings['RequireTermsOfServiceAcknowledgement'] = 'Exigir confirmação dos Termos de serviço';
        $strings['Required'] = 'Obrigatório';
        $strings['RequiredValue'] = 'Valor obrigatório';
        $strings['RequiresApproval'] = 'Requer aprovação';
        $strings['RequiresCheckInNotification'] = 'Requer check-in/out';
        $strings['Reservable'] = 'Reservável';
        $strings['ReservableTimeSlots'] = 'Intervalos de horários reserváveis';
        $strings['Reservation'] = 'Nova Reserva';
        $strings['ReservationApprovalAdminSubject'] = 'Notificação: Uma reserva necessita da sua aprovação';
        $strings['ReservationApprovalAdminSubjectWithResource'] = 'Notificação: Reserva para %s necessita da sua aprovação';
        $strings['ReservationApprovalPreference'] = 'Quando minha reserva pendente é aprovada';
        $strings['ReservationApprovedSubject'] = 'A sua reserva foi aprovada';
        $strings['ReservationApprovedSubjectWithResource'] = 'A reserva foi aprovada para  %s';
        $strings['ReservationCannotBeCheckedInTo'] = 'O check-in desta reserva não pode ser efetuado.';
        $strings['ReservationCannotBeCheckedOutFrom'] = 'O check-out desta reserva não pode ser efetuado.';
        $strings['ReservationColors'] = 'Cores das reservas';
        $strings['ReservationConflicts'] = 'Existem horários de reservas em conflito';
        $strings['ReservationCreated'] = 'A sua reserva foi criada com sucesso!';
        $strings['ReservationCreatedAdminSubject'] = 'Notificação: A reserva foi criada';
        $strings['ReservationCreatedAdminSubjectWithResource'] = 'Notificação: Reserva criada para %s';
        $strings['ReservationCreatedLog'] = 'Reserva criada. Número de referência %s';
        $strings['ReservationCreatedPreference'] = 'Quando eu criar uma reserva ou uma reserva é criada em meu nome';
        $strings['ReservationCreatedSubject'] = 'A sua reserva foi criada';
        $strings['ReservationCreatedSubjectWithResource'] = 'Reserva criada para %s';
        $strings['ReservationCriticalError'] = 'Ocorreu um erro crítico ao guardar a sua reserva. Se este erro continuar, contacte o seu administrador de sistema.';
        $strings['ReservationCustomRuleAdd'] = 'Use esta cor quando o atributo de reserva estiver definido com o seguinte valor';
        $strings['ReservationDeleteAdminSubject'] = 'Notificação: A reserva foi removida';
        $strings['ReservationDeleteAdminSubjectWithResource'] = 'Notificação: Reserva removida para %s';
        $strings['ReservationDeletedLog'] = 'Reserva removida. Número de referência %s';
        $strings['ReservationDeletedPreference'] = 'Quando eu excluir uma reserva ou uma reserva é excluída em meu nome';
        $strings['ReservationDeletedSubject'] = 'A sua reserva foi removida';
        $strings['ReservationDeletedSubjectWithResource'] = 'Reserva removida para %s';
        $strings['ReservationDescription'] = 'Descrição da reserva';
        $strings['ReservationDetails'] = 'Detalhes da reserva';
        $strings['ReservationEndingSoonSubject'] = 'A reserva de %s termina em breve';
        $strings['ReservationErrors'] = 'Alterar reserva';
        $strings['ReservationFailed'] = 'A sua reserva não pôde ser feita';
        $strings['ReservationImportInstructions'] = '<ul><li>O ficheiro deve estar em formato CSV com codificação UTF-8.</li><li>Email, nomes de recursos, início e fim são campos obrigatórios .</li><li>Início e fim exigem a data/hora completa. O formato recomendado é YYYY-mm-dd HH:mm (ex: 2017-12-31 20:30).</li><li>Regras, conflitos e intervalos de horários não serão verificados.</li><li>Serão enviadas notificações.</li><li>A validade dos atributos não será aplicada.</li><li>Separe com um vírgula múltiplos grupos de recursos.</li><li>Use o modelo fornecido como um exemplo.</li></ul>';
        $strings['ReservationLength'] = 'Duração da reserva';
        $strings['ReservationNotAvailable'] = 'A reserva não está disponível';
        $strings['ReservationNotFoundError'] = 'A reserva não foi encontrada';
        $strings['ReservationParticipantAccept'] = '%1$s aceitou seu convite de reserva para %2$s em %3$s';
        $strings['ReservationParticipantDecline'] = '%1$s recusou seu convite de reserva para %2$s em %3$s';
        $strings['ReservationParticipantJoin'] = '%1$s juntou-se à sua reserva para %2$s em %3$s';
        $strings['ReservationAvailableSubject'] = '%s está disponível em %s';
        $strings['ResourceStatusChangedSubject'] = 'A disponibilidade de %s foi alterada';
        $strings['ReservationParticipationActivityPreference'] = 'Quando alguém entra ou sai da minha reserva';
        $strings['ReservationRemoved'] = 'A sua reserva foi removida';
        $strings['ReservationRequiresApproval'] = 'Um ou mais dos recursos reservados requerem aprovação antes do uso. Esta reserva ficará pendente até que seja aprovada.';
        $strings['ReservationSeriesEndingPreference'] = 'Quando a série de reservas recorrentes está a terminar';
        $strings['ReservationSeriesEndingSubject'] = 'Série de reservas para %1$s está a terminar em %2$s';
        $strings['ReservationShareSubject'] = '%1$s partilhou uma reserva para %2$s';
        $strings['ReservationStartingSoonSubject'] = 'A reserva de %s começa em breve';
        $strings['ReservationTitle'] = 'Título da reserva';
        $strings['ReservationUpdated'] = 'A sua reserva foi atualizada com sucesso!';
        $strings['ReservationUpdatedAdminSubject'] = 'Notificação: A reserva foi atualizada';
        $strings['ReservationUpdatedAdminSubjectWithResource'] = 'Notificação: Reserva atualizada para %s';
        $strings['ReservationUpdatedLog'] = 'Reserva atualizada. Número de referência %s';
        $strings['ReservationUpdatedPreference'] = 'Quando eu atualizar uma reserva ou uma reserva é atualizada em meu nome';
        $strings['ReservationUpdatedSubject'] = 'A sua reserva foi atualizada';
        $strings['ReservationUpdatedSubjectWithResource'] = 'Reserva atualizada para %s';
        $strings['Reservations'] = 'Reservas';
        $strings['ReservationsWillBeDeleted'] = 'as reservas serão apagadas';
        $strings['ReservationsWillBePurged'] = 'as reservas serão eliminadas';
        $strings['Reserve'] = 'Reserve';
        $strings['ReserveLater'] = 'Reservar mais tarde';
        $strings['Reserved'] = 'Reservados';
        $strings['ReservedAccessories'] = 'Acessórios reservados';
        $strings['ReservedResources'] = 'Recursos reservados';
        $strings['Reset'] = 'Redefenir';
        $strings['ResetPassword'] = 'Pedido de redefinição de senha';
        $strings['ResetPasswordRequest'] = 'Pedido de reset de senha';
        $strings['Resource'] = 'Recurso';
        $strings['ResourceAdministrator'] = 'Administrador de recursos';
        $strings['ResourceAllowMultiDay'] = 'As reservas podem ser feitas através de dias';
        $strings['ResourceAvailability'] = 'Disponibilidade de recursos';
        $strings['ResourceBufferTime'] = 'Deve haver %s entre reservas';
        $strings['ResourceBufferTimeCsv'] = 'Duração do buffer';
        $strings['ResourceBufferTimeNone'] = 'Não existe um buffer entre reservas';
        $strings['ResourceCalendar'] = 'Calendário de Recursos';
        $strings['ResourceCapacity'] = 'Este recurso tem uma capacidade de %s pessoas';
        $strings['ResourceCapacityNone'] = 'Esse recurso tem capacidade ilimitada';
        $strings['ResourceColor'] = 'Cor do recurso';
        $strings['ResourceDisplayPrompt'] = 'Recurso a exibir';
        $strings['ResourceFilter'] = 'Filtro de recursos';
        $strings['ResourceGroupHelp1'] = 'Arrastar e largar grupos de recursos para reorganizar.';
        $strings['ResourceGroupHelp2'] = 'Clique com o botão do lado direito num nome de grupo de recursos para ações adicionais.';
        $strings['ResourceGroupHelp3'] = 'Arraste e largue recursos para os adicionar a grupos';
        $strings['ResourceGroupWarning'] = 'Se estiver a utilizar grupos de recursos, cada recurso deve ser atribuído a pelo menos um grupo. Recursos não atribuídos não poderão ser reservados.';
        $strings['ResourceGroups'] = 'Grupo de recursos';
        $strings['ResourceImages'] = 'Imagens dos recursos';
        $strings['ResourceImportInstructions'] = '<ul><li>O ficheiro deve estar em formato CSV com codificação UTF-8.</li><li>O nome é um campo obrigatório. Deixar os outros campos em branco irá defini-los os com valores padrão.</li><li>As opções de estado são \'Disponível\', \'Indisponível\' and \'Escondido\'.</li><li>A cor deverá ser um valor hexadecimal ex.: #ffffff.</li><li>As colunas de atribuição e aprovação automáticas podem ser verdadeiras ou falsas.</li><li>A validade dos atributos não será aplicada.</li><li>Separe com um vírgula múltiplos grupos de recursos.</li><li>As durações podem ser especificadas no formato #d#h#m ou HH:mm (1d3h30m ou 27:30 para 1 dia, 3 horas, 30 minutos)</li><li>Use o modelo fornecido como um exemplo.</li></ul>';
        $strings['ResourceList'] = 'Recursos a serem reservados';
        $strings['ResourceMaxLength'] = 'As reservas não podem durar mais de %s';
        $strings['ResourceMaxLengthCsv'] = 'Duração máxima da reserva';
        $strings['ResourceMaxLengthNone'] = 'Não há uma duração máxima de reserva';
        $strings['ResourceMaxNotice'] = 'As reservas não devem terminar mais de %s a partir do tempo atual';
        $strings['ResourceMaxNoticeCsv'] = 'Fim máximo da reserva';
        $strings['ResourceMaxNoticeNone'] = 'As reservas podem acabar a qualquer momento no futuro';
        $strings['ResourceMinLength'] = 'As reservas devem durar pelo menos %s';
        $strings['ResourceMinLengthCsv'] = 'Duração mínima da reserva';
        $strings['ResourceMinLengthNone'] = 'Não há uma duração mínima de reserva';
        $strings['ResourceMinNotice'] = 'As reservas devem ser feitas pelo menos %s antes da hora de início';
        $strings['ResourceMinNoticeAddCsv'] = 'Adicionar aviso prévio mínimo de reserva';
        $strings['ResourceMinNoticeDelete'] = 'As reservas têm que ser apagadas até pelo menos %s antes da hora de ínicio';
        $strings['ResourceMinNoticeDeleteCsv'] = 'Aviso prévio mínimo de eliminação de reserva';
        $strings['ResourceMinNoticeNone'] = 'As reservas podem ser feitas até o tempo atual';
        $strings['ResourceMinNoticeNoneDelete'] = 'As reservas podem ser apagadas até o tempo atual';
        $strings['ResourceMinNoticeNoneUpdate'] = 'As reservas podem ser atualizadas até o tempo atual';
        $strings['ResourceMinNoticeUpdate'] = 'As reservas têm que ser atualizadas pelo menos %s antes da hora de ínicio';
        $strings['ResourceMinNoticeUpdateCsv'] = 'Atualizar aviso prévio mínimo de reserva';
        $strings['ResourceNotAllowMultiDay'] = 'As reservas não podem ser feitas através de dias';
        $strings['ResourcePermissionAutoGranted'] = 'A permissão é concedida automaticamente';
        $strings['ResourcePermissionNotAutoGranted'] = 'A permissão não é concedida automaticamente';
        $strings['ResourcePermissions'] = 'Permissões de recursos';
        $strings['ResourceRequiresApproval'] = 'As reservas devem ser aprovadas';
        $strings['ResourceRequiresApprovalNone'] = 'Reservas não necessitam aprovação';
        $strings['ResourceReservations'] = 'Reservas de Recurso';
        $strings['ResourceStatus'] = 'Estado do recurso';
        $strings['ResourceType'] = 'Tipo de recurso';
        $strings['ResourceUsageReservationCount'] = 'Utilização de recursos - Contagem de reservas';
        $strings['ResourceUsageTimeBooked'] = 'Utilização de recursos - Tempo reservado';
        $strings['Resources'] = 'Recursos';
        $strings['Responsibilities'] = 'Responsabilidades';
        $strings['Restricted'] = 'Restrito';
        $strings['Retry'] = 'Tentar novamente';
        $strings['RetrySkipConflicts'] = 'Ignorar reservas em conflito';
        $strings['ReturnToPreviousPage'] = 'Regressar à página anterior';
        $strings['Rows'] = 'Linhas';
        $strings['RowsImported'] = 'Linhas importadas';
        $strings['RowsSkipped'] = 'Linhas ignoradas';
        $strings['RunInstallation'] = 'Iniciar instalação';
        $strings['RunReport'] = 'Executar relatório';
        $strings['RunUpgrade'] = 'Iniciar atualização';
        $strings['SQLStatement'] = 'Instrução SQL:';
        $strings['Sandbox'] = 'Sandbox';
        $strings['SaveThisReport'] = 'Guardar este relatório';
        $strings['Schedule'] = 'Agenda';
        $strings['ScheduleAdministrator'] = 'Administrador de agenda';
        $strings['ScheduleAvailabilityEarly'] = 'Esta agenda ainda não está disponível. Está disponível';
        $strings['ScheduleAvailabilityError'] = 'Este horário está disponível entre %1$s e %2$s';
        $strings['ScheduleAvailabilityLate'] = 'Esta agenda já não está disponível. Estava disponível';
        $strings['ScheduleCalendar'] = 'Calendário de agendas';
        $strings['ScheduleLayout'] = 'Disposição (todos os horários %s)';
        $strings['ScheduleReservations'] = 'Agendar Reservas';
        $strings['Schedules'] = 'Agendas';
        $strings['ScriptUrlWarning'] = 'A definição <em>script.url</em> pode não estar correta. Atualmente é <strong>%1$s</strong>, acreditámos que deveria ser <strong>%2$s</strong>';
        $strings['Search'] = 'Pesquisar';
        $strings['SearchReservations'] = 'Pesquisar reservas';
        $strings['SecurityCode'] = 'Código de Segurança';
        $strings['Select'] = 'Selecionar';
        $strings['SelectEmailTemplate'] = 'Seleccione o modelo de email';
        $strings['SelectList'] = 'Lista de seleção';
        $strings['SelectUser'] = 'Seleccionar utilizador';
        $strings['SendAsEmail'] = 'Enviar email como';
        $strings['SendReminder'] = 'Enviar lembrete';
        $strings['ServerSettings'] = 'Configurações do Servidor';
        $strings['SetInstallPassword'] = 'É necessário definir uma senha de instalação antes de poder iniciar a instalação.';
        $strings['ShowFullWeek'] = 'Mostrar semana completa';
        $strings['ShowHide'] = 'Mostrar/Ocultar';
        $strings['ShowHideNavigation'] = 'Mostrar/Ocultar navegação';
        $strings['SignIn'] = 'Entrar';
        $strings['SignOut'] = 'Sair';
        $strings['SignedInAs'] = 'Logado como';
        $strings['SingleLineTextbox'] = 'Caixa de texto de linha única';
        $strings['SlackBookNow'] = 'Reserve agora';
        $strings['SlackBookResource'] = 'Reserve %s agora';
        $strings['SlackNotFound'] = 'Não foi possível encontrar um recurso com esse nome. Reserve agora para iniciar uma nova reserva.';
        $strings['SortOrder'] = 'Ordem';
        $strings['SpecificDates'] = 'Mostrar datas específicas';
        $strings['SpecificTime'] = 'Tempo específico';
        $strings['Standard'] = 'Padrão';
        $strings['StandardScheduleDisplay'] = 'Utilize a exibição de agenda padrão';
        $strings['StartDateBeforeEndDateRule'] = 'A data de início deve ser anterior à data de término';
        $strings['StartIsInPast'] = 'A data de início não pode ser no passado';
        $strings['StartTime'] = 'Hora de início';
        $strings['StartsOn'] = 'Inicia em';
        $strings['StatementFailed'] = 'Falhou. Detalhes:';
        $strings['Status'] = 'Estado';
        $strings['StripePublishableKey'] = 'Publishable key';
        $strings['StripeSecretKey'] = 'Secret key';
        $strings['SubscribeToCalendar'] = 'Assinar este calendário';
        $strings['SubscriptionsAreDisabled'] = 'O administrador desabilitou assinaturas de calendário';
        $strings['Success'] = 'Sucesso';
        $strings['SwitchLayoutWarning'] = 'Tem certeza de que deseja alterar o tipo de disposição? Isso removerá todos os intervalos de horários existentes.';
        $strings['SwitchToACustomLayout'] = 'Mudar para disposição personalizada';
        $strings['SwitchToAStandardLayout'] = 'Mudar para disposição padrão';
        $strings['TakeOffline'] = 'Colocar Offline';
        $strings['Tall'] = 'Alto';
        $strings['TallScheduleDisplay'] = 'Utilize a exibição de agenda alta';
        $strings['TermsOfService'] = 'Termos de serviço';
        $strings['TermsOfServiceError'] = 'Tem que aceitar os termos de serviço';
        $strings['TheTermsOfService'] = 'os Termos de serviço';
        $strings['ThemeUploadSuccess'] = 'As suas alterações foram salvas. Atualize a página para que as alterações entrem em vigor.';
        $strings['ThisInstance'] = 'Apenas esta instância';
        $strings['ThisIsTheDefaultSchedule'] = 'Esta é a agenda padrão';
        $strings['ThisScheduleUsesACustomLayout'] = 'Esta agenda utiliza uma disposição personalizada';
        $strings['ThisScheduleUsesAStandardLayout'] = 'Esta agenda utiliza uma disposição padrão';
        $strings['ThisWeek'] = 'Esta semana';
        $strings['Timezone'] = 'Fuso Horário';
        $strings['Title'] = 'Título';
        $strings['TitleRequiredRule'] = 'O título da reserva é obrigatório';
        $strings['Today'] = 'Hoje';
        $strings['Tomorrow'] = 'Amanhã';
        $strings['Top20UsersReservationCount'] = 'Top 20 de utilizadores - Contagem de reservas';
        $strings['Top20UsersTimeBooked'] = 'Top 20 de utilizadores - Tempo reservado';
        $strings['Total'] = 'Total';
        $strings['TotalTime'] = 'Tempo';
        $strings['TransactionFee'] = 'Taxa de transação';
        $strings['TransactionHistory'] = 'Histórico de transações';
        $strings['TransactionId'] = 'ID da transação';
        $strings['Transactions'] = 'Transações';
        $strings['True'] = 'Verdadeiro';
        $strings['TryAgain'] = 'Tente novamente';
        $strings['TurnOffSubscription'] = 'Esconder do público';
        $strings['TurnOnSubscription'] = 'Mostrar ao público (RSS, iCalendar, Tablet, Monitor)';
        $strings['Type'] = 'Tipo';
        $strings['Unavailable'] = 'Indisponível';
        $strings['UnavailableAllDay'] = 'Indisponível todo o dia';
        $strings['UnavailableNow'] = 'Indisponível agora';
        $strings['Unchanged'] = 'Inalterada';
        $strings['UniqueEmailRequired'] = 'Este endereço de e-mail já está registrado.';
        $strings['UniquePerInstance'] = 'Único por instância';
        $strings['UniqueUsernameRequired'] = 'Esse nome de utilizador já está registrado.';
        $strings['UnknownError'] = 'Erro Desconhecido';
        $strings['Unlimited'] = 'Ilimitado';
        $strings['Unreservable'] = 'Não reservável';
        $strings['UpcomingReservations'] = 'Reservas Futuras';
        $strings['Update'] = 'Atualizar';
        $strings['UpdateEmailTemplateFailure'] = 'Não foi possível atualizar o modelo de email. Por favor confirme que a pasta tem permissões de escrita';
        $strings['UpdateEmailTemplateSuccess'] = 'Modelo de email atualizado';
        $strings['UpdateResourcesOnImport'] = 'Atualizar recursos existentes se o nome já existir';
        $strings['UpdateUsersOnImport'] = 'Atualizar utilizador existente se o email já existir';
        $strings['Updated'] = 'Atualizado';
        $strings['UpdatingReservation'] = 'Atualizando reserva';
        $strings['UpgradeNotice'] = 'Está a atualizar da versão <b>%1$s</b> para a versão <b>%2$s</b>';
        $strings['UploadTerms'] = 'Carregar Termos de serviço';
        $strings['UponRegistration'] = 'Após o registo';
        $strings['UponReservation'] = 'Após a reserva';
        $strings['Usage'] = 'Utilização';
        $strings['UsageConfiguration'] = 'Configuração de utilização';
        $strings['UseSameLayoutAs'] = 'Usar a mesma disposição como';
        $strings['UseSameLayoutForAllDays'] = 'Utilizar a mesma disposição para todos os dias';
        $strings['User'] = 'Utilizador';
        $strings['UserAdded'] = 'Um novo utilizador foi adicionado';
        $strings['UserDeleted'] = 'Conta de utilizador para %1$s foi apagada por %2$s';
        $strings['UserImportInstructions'] = '<ul><li>O ficheiro deve estar em formato CSV.</li><li>Nome de utilizador e email são campos obrigatórios.</li><li>A validade dos atributos não será aplicada.</li><li>Se deixar os outros campos em branco estes serão preenchidos com os valores padrão e a senha \'password\' como a senha do utilizador.</li><li>Use o modelo fornecido como um exemplo.</li></ul>';
        $strings['UserNameRequired'] = 'Nome de utilizador é obrigatório.';
        $strings['UserNotFound'] = 'Não foi possível encontrar o utilizador';
        $strings['UserPermissionInfo'] = 'O acesso efetivo ao recurso pode ser diferente dependendo da função do utilizador, permissões de grupo, ou definições de permissões externas';
        $strings['Username'] = 'Utilizador';
        $strings['UsernameOrEmail'] = 'Utilizador ou E-mail';
        $strings['Users'] = 'Utilizadores';
        $strings['UsersInGroup'] = 'Utilizadores neste grupo';
        $strings['UsersInGroups'] = 'Utilizadores em grupos';
        $strings['UsersWillBeDeleted'] = 'os utilizadores serão apagados';
        $strings['UsersWithAccessToResources'] = 'Utilizadores com acesso aos recursos';
        $strings['Utilization'] = 'Utilização';
        $strings['ValidEmailRequired'] = 'Um endereço de e-mail válido é obrigatório.';
        $strings['ValidLayoutRequired'] = 'Intervalos devem ser fornecidos para todas as 24 horas do dia começando e terminando às 12:00.';
        $strings['ValidationExpression'] = 'Expressão de validação';
        $strings['VerifyInstallSettings'] = 'Verifique as seguintes definições padrão antes de continuar. Ou pode modificá-las em %s.';
        $strings['ViewAll'] = 'Ver todos';
        $strings['ViewAsChart'] = 'Ver como gráfico';
        $strings['ViewAvailability'] = 'Ver disponibilidade';
        $strings['ViewCalendar'] = 'Ver calendário';
        $strings['ViewDay'] = 'Ver dia';
        $strings['ViewOnly'] = 'Apenas visualização';
        $strings['ViewReservation'] = 'Ver reserva';
        $strings['ViewReservationHeading'] = 'Visualização de reserva %s';
        $strings['ViewSchedule'] = 'Ver agendas';
        $strings['ViewTerms'] = 'Ver Termos de serviço';
        $strings['ViewYourCredits'] = 'Ver os seus créditos';
        $strings['WaitlistRequestAdded'] = 'Será notificado se este horário ficar disponível';
        $strings['WeNeedYourEmailAddress'] = 'Necessitamos do seu endereço de email para reservar';
        $strings['Week'] = 'Semana';
        $strings['Weekly'] = 'Semanal';
        $strings['WhatCanThisGroupManage'] = 'O que pode este grupo gerir?';
        $strings['WhatRolesApplyToThisGroup'] = 'Que regras se aplicam a este grupo?';
        $strings['WhatsNew'] = 'O que há de novo?';
        $strings['WhoCanManageThisGroup'] = 'Quem pode gerir este grupo?';
        $strings['WhoCanManageThisResource'] = 'Quem pode gerir este recurso?';
        $strings['WhoCanManageThisSchedule'] = 'Quem pode gerir esta agenda?';
        $strings['Wide'] = 'Largo';
        $strings['WideScheduleDisplay'] = 'Utilize a exibição de agenda larga';
        $strings['Working'] = 'Trabalhando...';
        $strings['Yearly'] = 'Anual';
        $strings['Yes'] = 'Sim';
        $strings['YouAreAParticipant'] = 'É um participante desta reserva';
        $strings['YouAreInvited'] = 'Foi convidado para esta reserva';
        $strings['YouCanJoinThisReservation'] = 'Pode participar desta reserva';
        $strings['YouWillBeEmailedANewPassword'] = 'Receberá um e-mail com uma nova senha gerada aleatoriamente';
        $strings['YourCredits'] = 'Os seus créditos';
        $strings['YourProfileWasUpdated'] = 'O seu perfil foi atualizado';
        $strings['YourReferenceNumber'] = 'O seu número de referência é %s';
        $strings['YourSettingsWereUpdated'] = 'As suas configurações foram atualizadas';
        $strings['day'] = 'dia';
        $strings['days'] = 'dias';
        $strings['firsttimeuser'] = 'Está a usar pela primeira vez?';
        $strings['hours'] = 'horas';
        $strings['minutes'] = 'minutos';
        $strings['month'] = 'mês';
        $strings['months'] = 'meses';
        $strings['or'] = 'ou';
        $strings['repeatDayOfMonth'] = 'dia do mês';
        $strings['repeatDayOfWeek'] = 'dia da semana';
        $strings['reservation'] = 'reserva';
        $strings['reservations'] = 'reservas';
        $strings['week'] = 'semana';
        $strings['weeks'] = 'semanas';
        $strings['year'] = 'ano';
        $strings['years'] = 'anos';
        //2.8.4.
        $strings['Custom'] = 'Personalizado';
        $strings['AddDate'] = 'Adicionar data';
        $strings['RepeatOn'] = 'Repetir em';
        $strings['ScheduleConcurrentMaximum'] = 'Um total de <b>%s</b> recursos podem ser reservados em simultâneo';
        $strings['ScheduleConcurrentMaximumNone'] = 'Não existe limite para o número de recursos reservados em simultâneo';
        $strings['ScheduleMaximumConcurrent'] = 'Número máximo de recursos que podem ser reservados em simultâneo';
        $strings['ScheduleMaximumConcurrentNote'] = 'Quando definido, o número total de recursos que podem ser reservados em simultâneo nesta agenda será limitado.';
        $strings['ScheduleResourcesPerReservationMaximum'] = 'Cada reserva está limitada a um máximo de <b>%s</b> recursos';
        $strings['ScheduleResourcesPerReservationNone'] = 'Não existe limite para o número de recursos por reserva';
        $strings['ScheduleResourcesPerReservation'] = 'Número máximo de recursos por reserva';
        $strings['ResourceConcurrentReservations'] = 'Permitir %s reservas em simultâneo';
        $strings['ResourceConcurrentReservationsNone'] = 'Não permitir reservas em simultâneo';
        $strings['AllowConcurrentReservations'] = 'Permitir reservas em simultâneo';
        $strings['ResourceDisplayInstructions'] = 'Não foi seleccionado nenhum recurso. Pode encontrar o endereço para exibir um recurso na Gestão da Aplicação, Recursos. O recurso deverá estar públicamente acessivel.';
        $strings['Owner'] = 'Proprietário';
        $strings['MaximumConcurrentReservations'] = 'Número máximo de reservas em simultâneo';
        $strings['InstancesOverlapRule'] = 'Algumas instâncias da serie de reservas sobrepõem-se:';
        $strings['InvalidNumberOfResourcesError'] = 'O número máximo de recursos que pode ser reservado numa única reserva é de %s';
        $strings['ScheduleTotalReservationsError'] = 'Esta agenda apenas permite que %s recursos sejam reservados em simultâneo. Esta reserva iria violar este limite nas seguintes datas:';
        $strings['GroupMembership'] = 'Membros do grupo';
        $strings['AvailableGroups'] = 'Grupos disponiveis';
        //--30092020
        $strings['NotifyUsers'] = 'Notificar utilizadores';
        $strings['Message'] = 'Mensagem';
        $strings['AllUsersWhoHaveAReservationInTheNext'] = 'Qualquer um com uma reserva na(o) seguinte';
        $strings['ChangeResourceStatus'] = 'Alterar estado do recurso';
        $strings['UpdateGroupsOnImport'] = 'Atualizar o grupo existente se o nome corresponder';
        $strings['GroupsImportInstructions'] = '<ul><li>O ficheiro deverá estar em formato CSV.</li><li>O nome é obrigatório.</li><li>As listas de membros deverão ser listas de emails separados por vírgulas.</li><li>Listas de membros vazias durante a atualização deixarão os membros inalterados.</li><li>As listas de permissões deverão ser listas de nomes de recursos separados por vírgulas.</li><li>Listas de permissões vazias durante a atualização de grupos deixarão as permissões inalteradas.</li><li>Utilize o modelo fornecido como exemplo.</li></ul>';
        $strings['PhoneRequired'] = 'O telefone é obrigatório';
        $strings['OrganizationRequired'] = 'A organização é obrigatória';
        $strings['PositionRequired'] = 'A posição é obrigatória';
        $strings['AvailableGroups'] = 'Grupos disponiveis';
        $strings['CheckingAvailabilityError'] = 'Não é possível obter a disponibilidade do recurso - demasiados recursos';
        //--

        //Past Reservations
        $strings['NoPastReservations'] = 'Não tem reservas passadas';
        $strings['PastReservations'] = 'Reservas Passadas';
        $strings['AllNoPastReservations'] = 'Não existem reservas passadas nos anteriores %s dias';
        $strings['AllPastReservations'] = 'Todas as Reservas Passadas';
        $strings['Yesterday'] = 'Ontem';
        $strings['EarlierThisWeek'] = 'Anteriormente Nesta Semana';
        $strings['PreviousWeek'] = 'Semana Passada';
        //End Past Reservations

        //Group Upcoming Reservations
        $strings['NoGroupUpcomingReservations'] = 'O seu grupo não tem reservas futuras';
        $strings['GroupUpcomingReservations'] = 'Reservas Futuras do(s) meu(s) Grupo(s)';
        //End Group Upcoming Reservations

        //Facebook Login SDK Error
        $strings['FacebookLoginErrorMessage'] = 'Ocorreu um erro ao fazer login com o Facebook. Por favor, tente novamente.';
        //End Facebook Login SDK Error

        //Pending Approval Reservations in Dashboard
        $strings['NoPendingApprovalReservations'] = 'Não existem reservas aguardando aprovação';
        $strings['PendingApprovalReservations'] = 'Reservas Aguardando Aprovação';
        $strings['LaterThisMonth'] = 'Ainda este mês';
        $strings['LaterThisYear'] = 'Ainda este ano';
        $strings['Remaining'] = 'Restantes';
        //End Pending Approval Reservations in Dashboard

        //Missing Check In/Out Reservations in Dashboard
        $strings['NoMissingCheckOutReservations'] = 'Não há reservas de check-out em falta';
        $strings['MissingCheckOutReservations'] = 'Reservas que Falharam Check Out';
        //End Missing Check In/Out Reservations in Dashboard
        
        //Schedule Resource Permissions
        $strings['NoResourcePermissions'] = 'Não é possível ver os detalhes da reserva uma vez que não tem permissões para nenhum dos recursos';
        //End Schedule Resource Permissions

        //View Resource
        $strings['Check'] = 'Consultar';
        $strings['PermissionType'] = 'Tipo de Permissão';
        $strings['NoResourcesToView'] = 'Sem recursos disponíveis';
        //End View Resource

        $this->Strings = $strings;

        return $this->Strings;
    }

    /**
     * @return array
     */
    protected function _LoadDays()
    {
        $days = parent::_LoadDays();

        /***
        DAY NAMES
        All of these arrays MUST start with Sunday as the first element
        and go through the seven day week, ending on Saturday
         ***/
        // The full day name
        $days['full'] = ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'];
        // The three letter abbreviation
        $days['abbr'] = ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb'];
        // The two letter abbreviation
        $days['two'] = ['Do', 'Se', 'Te', 'Qu', 'Qu', 'Se', 'Sá'];
        // The one letter abbreviation
        $days['letter'] = ['D', 'S', 'T', 'Q', 'Q', 'S', 'S'];

        $this->Days = $days;

        return $this->Days;
    }

    /**
     * @return array
     */
    protected function _LoadMonths()
    {
        $months = parent::_LoadMonths();

        /***
        MONTH NAMES
        All of these arrays MUST start with January as the first element
        and go through the twelve months of the year, ending on December
         ***/
        // The full month name
        $months['full'] = ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'];
        // The three letter month name
        $months['abbr'] = ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'];

        $this->Months = $months;

        return $this->Months;
    }

    /**
     * @return array
     */
    protected function _LoadLetters()
    {
        $this->Letters = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];

        return $this->Letters;
    }

    protected function _GetHtmlLangCode()
    {
        return 'pt_pt';
    }
}
