<?php

require_once('Language.php');
require_once('en_gb.php');

class fr_fr extends en_gb
{
    public function __construct()
    {
        parent::__construct();
    }

    protected function _LoadStrings()
    {
        $strings = parent::_LoadStrings();

        $strings['FirstName'] = 'Prénom';
        $strings['LastName'] = 'Nom';
        $strings['Timezone'] = 'Fuseau horaire';
        $strings['Edit'] = 'Editer';
        $strings['Change'] = 'Modifier';
        $strings['Rename'] = 'Renommer';
        $strings['Remove'] = 'Enlever';
        $strings['Delete'] = 'Effacer';
        $strings['Update'] = 'Enregistrer';
        $strings['Cancel'] = 'Annuler';
        $strings['Add'] = 'Ajouter';
        $strings['Name'] = 'Nom';
        $strings['Yes'] = 'Oui';
        $strings['No'] = 'Non';
        $strings['FirstNameRequired'] = 'Le prénom est obligatoire.';
        $strings['LastNameRequired'] = 'Le nom est obligatoire.';
        $strings['PwMustMatch'] = 'La confirmation du mot de passe doit correspondre avec le mot de passe.';
        $strings['ValidEmailRequired'] = 'Un email valide est obligatoire.';
        $strings['UniqueEmailRequired'] = 'Cette adresse email est déjà enregistrée.';
        $strings['UniqueUsernameRequired'] = 'Ce nom d\'utilisateur est déjà enregistré.';
        $strings['UserNameRequired'] = 'Le nom d\'utilisateur est obligatoire.';
        $strings['CaptchaMustMatch'] = 'Veuillez saisir les lettres contenues dans l\'image (sécurité).';
        $strings['Today'] = 'Aujourd\'hui';
        $strings['Week'] = 'Semaine';
        $strings['Month'] = 'Mois';
        $strings['BackToCalendar'] = 'Retour au calendrier';
        $strings['BeginDate'] = 'Début';
        $strings['EndDate'] = 'Fin';
        $strings['Username'] = 'Nom d\'utilisateur';
        $strings['Password'] = 'Mot de Passe';
        $strings['PasswordConfirmation'] = 'Confirmez votre mot de passe';
        $strings['DefaultPage'] = 'Page d\'accueil';
        $strings['MyCalendar'] = 'Mon Calendrier';
        $strings['ScheduleCalendar'] = 'Calendrier du planning';
        $strings['Registration'] = 'Enregistrement';
        $strings['NoAnnouncements'] = 'Il n\'y a aucune annonce';
        $strings['Announcements'] = 'Annonces';
        $strings['NoUpcomingReservations'] = 'Vous n\'avez aucune réservation à venir';
        $strings['UpcomingReservations'] = 'Réservations à venir';
        $strings['AllNoUpcomingReservations'] = 'Il n\'y a pas de réservations dans les %s prochains jours';
        $strings['AllUpcomingReservations'] = 'Toutes les Réservations à Venir';
        $strings['ShowHide'] = 'Afficher/Cacher';
        $strings['Error'] = 'Erreur';
        $strings['ReturnToPreviousPage'] = 'Retour à la page précédente';
        $strings['UnknownError'] = 'Erreur inconnue';
        $strings['InsufficientPermissionsError'] = 'Vous n\'avez pas le droit d\'accéder à cette ressource';
        $strings['MissingReservationResourceError'] = 'Pas de ressource sélectionnée';
        $strings['MissingReservationScheduleError'] = 'Pas de planning sélectionné';
        $strings['DoesNotRepeat'] = 'Aucune';
        $strings['Daily'] = 'Journalière';
        $strings['Weekly'] = 'Hebdomadaire';
        $strings['Monthly'] = 'Mensuelle';
        $strings['Yearly'] = 'Annuelle';
        $strings['RepeatPrompt'] = 'Répétition';
        $strings['hours'] = 'heures';
        $strings['days'] = 'jours';
        $strings['weeks'] = 'semaines';
        $strings['months'] = 'mois';
        $strings['years'] = 'années';
        $strings['day'] = 'jour';
        $strings['week'] = 'semaine';
        $strings['month'] = 'mois';
        $strings['year'] = 'année';
        $strings['repeatDayOfMonth'] = 'Jour du mois';
        $strings['repeatDayOfWeek'] = 'Jour de la semaine';
        $strings['RepeatUntilPrompt'] = 'Jusqu\'au';
        $strings['RepeatEveryPrompt'] = 'Tous les';
        $strings['RepeatDaysPrompt'] = 'On';//
        $strings['CreateReservationHeading'] = 'Créer une nouvelle réservation';
        $strings['EditReservationHeading'] = 'Editer la réservation %s';
        $strings['ViewReservationHeading'] = 'Visualisation de la réservation %s';
        $strings['ReservationErrors'] = 'Changer la Réservation';
        $strings['Create'] = 'Créer';
        $strings['ThisInstance'] = 'Cette Instance seule';
        $strings['AllInstances'] = 'Toutes les Instances';
        $strings['FutureInstances'] = 'Futures Instances';
        $strings['Print'] = 'Imprimer';
        $strings['ShowHideNavigation'] = 'Afficher/Cacher le Menu';
        $strings['ReferenceNumber'] = 'Numéro de Référence';
        $strings['Tomorrow'] = 'Demain';
        $strings['LaterThisWeek'] = 'Reste de la semaine';
        $strings['NextWeek'] = 'La semaine prochaine';
        $strings['SignOut'] = 'Déconnexion';
        $strings['LayoutDescription'] = 'Commence le %s, Affiche %s jours à la fois';
        $strings['AllResources'] = 'Toutes les Ressources';
        $strings['TakeOffline'] = 'Désactiver';
        $strings['BringOnline'] = 'Activer';
        $strings['AddImage'] = 'Ajouter une Image';
        $strings['NoImage'] = 'Pas d\'image';
        $strings['Move'] = 'Déplacer';
        $strings['AppearsOn'] = 'Affiché sur %s';
        $strings['Location'] = 'Emplacement';
        $strings['NoLocationLabel'] = '(pas d\'emplacement)';
        $strings['Contact'] = 'Contact';
        $strings['NoContactLabel'] = '(aucun contact disponible)';
        $strings['Description'] = 'Description';
        $strings['NoDescriptionLabel'] = '(pas de description)';
        $strings['Notes'] = 'Notes';
        $strings['NoNotesLabel'] = '(pas de notes)';
        $strings['NoTitleLabel'] = '(pas de libellé)';
        $strings['UsageConfiguration'] = 'Règles d\'Utilisation';
        $strings['ChangeConfiguration'] = 'Modifier';
        $strings['ResourceMinLength'] = 'Les réservations doivent durer au minimum %s';
        $strings['ResourceMinLengthNone'] = 'Pas de durée minimum de réservation';
        $strings['ResourceMaxLength'] = 'Les réservations ne peuvent durer plus de %s';
        $strings['ResourceMaxLengthNone'] = 'Pas de durée maximum de réservation';
        $strings['ResourceRequiresApproval'] = 'Les réservations nécessitent une approbation';
        $strings['ResourceRequiresApprovalNone'] = 'Les réservations ne nécessitent pas d\'approbation';
        $strings['ResourcePermissionAutoGranted'] = 'La permission est automatique';
        $strings['ResourcePermissionNotAutoGranted'] = 'La permission n\'est pas automatique';
        $strings['ResourceMinNotice'] = 'Les réservations doivent être créées au moins %s avant l\'heure de début de réservation';
        $strings['ResourceMinNoticeNone'] = 'Les réservations peuvent être saisies jusqu\'au dernier moment ';
        $strings['ResourceMinNoticeUpdate'] = 'Les réservations doivent être mises à jour au moins %s avant l\'heure de début';
        $strings['ResourceMinNoticeNoneUpdate'] = 'Les réservations peuvent être mises à jour jusqu\' au moment présent';
        $strings['ResourceMinNoticeDelete'] = 'Les réservations doivent être supprimées au moins %s avant l\'heure de début';
        $strings['ResourceMinNoticeNoneDelete'] = 'Les réservations peuvent être supprimées jusqu\' au moment présent';
        $strings['ResourceMaxNotice'] = 'Les réservations ne doivent pas finir plus loin que %s du moment présent';
        $strings['ResourceMaxNoticeNone'] = 'Les réservations peuvent finir n\'importe quand';
        $strings['ResourceBufferTime'] = 'Il doit y avoir %s entre les réservations';
        $strings['ResourceBufferTimeNone'] = 'Il n\'y a pas de laps de temps entre les réservations';
        $strings['ResourceAllowMultiDay'] = 'Les réservations peuvent être à cheval sur plusieurs jours';
        $strings['ResourceNotAllowMultiDay'] = 'Les réservations ne peuvent pas être à cheval sur plusieurs jours';
        $strings['ResourceCapacity'] = 'Cette ressource a une capacité de %s personne(s)';
        $strings['ResourceCapacityNone'] = 'Cette ressource a une capacité non limitée';
        $strings['AddNewResource'] = 'Ajouter une Nouvelle Ressource';
        $strings['AddNewUser'] = 'Ajouter un Nouvel Utilisateur';
        $strings['AddResource'] = 'Ajouter une Ressource';
        $strings['Capacity'] = 'Capacité';
        $strings['Access'] = 'Accès';
        $strings['Duration'] = 'Durée';
        $strings['Active'] = 'Actif';
        $strings['Inactive'] = 'Inactif';
        $strings['ResetPassword'] = 'Réinitialiser le Mot de Passe';
        $strings['LastLogin'] = 'Dernière Connexion';
        $strings['Search'] = 'Chercher';
        $strings['ResourcePermissions'] = 'Permissions de la Ressource';
        $strings['Reservations'] = 'Réservations';
        $strings['Groups'] = 'Groupes';
        $strings['Users'] = 'Utilisateurs';
        $strings['AllUsers'] = 'Tous les Utilisateurs';
        $strings['AllGroups'] = 'Tous les Groupes';
        $strings['AllSchedules'] = 'Tous les Plannings';
        $strings['UsernameOrEmail'] = 'Nom d\'utilisateur ou Email';
        $strings['Members'] = 'Membres';
        $strings['QuickSlotCreation'] = 'Créer des créneaux toutes les %s minutes entre %s et %s';
        $strings['ApplyUpdatesTo'] = 'Appliquer les Mises à jour à';
        $strings['CancelParticipation'] = 'Annuler la Participation';
        $strings['Attending'] = 'Attending';//
        $strings['QuotaConfiguration'] = 'Sur %s pour %s les utilisateurs de %s sont limités à %s %s par %s';
        $strings['QuotaEnforcement'] = 'Contrainte %s %s';
        $strings['reservations'] = 'réservations';
        $strings['reservation'] = 'réservation';
        $strings['ChangeCalendar'] = 'Changer de Calendrier';
        $strings['AddQuota'] = 'Ajouter un Quota';
        $strings['FindUser'] = 'Chercher un Utilisateur';
        $strings['Created'] = 'Créé';
        $strings['LastModified'] = 'Dernière Modification';
        $strings['GroupName'] = 'Nom du Groupe';
        $strings['GroupMembers'] = 'Membres du Groupe';
        $strings['GroupRoles'] = 'Rôles du Groupe';
        $strings['GroupAdmin'] = 'Administrateur du Groupe';
        $strings['Actions'] = 'Actions';
        $strings['CurrentPassword'] = 'Mot de Passe Actuel';
        $strings['NewPassword'] = 'Nouveau Mot de Passe';
        $strings['InvalidPassword'] = 'Le Mot de Passe Actuel est incorrect';
        $strings['PasswordChangedSuccessfully'] = 'Votre Mot de Passe a été modifié avec succès';
        $strings['SignedInAs'] = 'Utilisateur :';
        $strings['NotSignedIn'] = 'Vous n\'êtes pas connecté !';
        $strings['ReservationTitle'] = 'Libellé de la réservation';
        $strings['ReservationDescription'] = 'Description de la réservation';
        $strings['ResourceList'] = 'Ressources réservables';
        $strings['Accessories'] = 'Accessoires';
        $strings['InvitationList'] = 'Invités';
        $strings['AccessoryName'] = 'Nom de l\'accessoire';
        $strings['QuantityAvailable'] = 'Quantité disponible';
        $strings['Resources'] = 'Ressources';
        $strings['Participants'] = 'Participants';
        $strings['User'] = 'Utilisateur';
        $strings['Resource'] = 'Ressource';
        $strings['Status'] = 'Statut';
        $strings['Approve'] = 'Approuver';
        $strings['Page'] = 'Page';
        $strings['Rows'] = 'Lignes';
        $strings['Unlimited'] = 'Illimité';
        $strings['Email'] = 'Email';
        $strings['EmailAddress'] = 'Adresse Email';
        $strings['Phone'] = 'Téléphone';
        $strings['Organization'] = 'Organisation';
        $strings['Position'] = 'Poste';
        $strings['Language'] = 'Langue';
        $strings['Permissions'] = 'Permissions';
        $strings['Reset'] = 'Réinitialisation';
        $strings['FindGroup'] = 'Chercher un Groupe';
        $strings['Manage'] = 'Gérer';
        $strings['None'] = 'Aucun';
        $strings['AddToOutlook'] = 'Ajouter à Outlook';
        $strings['Done'] = 'Valider';
        $strings['RememberMe'] = 'Se souvenir de moi';
        $strings['FirstTimeUser?'] = 'Débutant ?';
        $strings['CreateAnAccount'] = 'Créer un compte';
        $strings['ViewSchedule'] = 'Voir le planning';
        $strings['ForgotMyPassword'] = 'J\'ai oublié mon Mot de Passe';
        $strings['YouWillBeEmailedANewPassword'] = 'Vous allez recevoir par email un nouveau mot de passe généré automatiquement';
        $strings['Close'] = 'Fermer';
        $strings['ExportToCSV'] = 'Exporter en CSV';
        $strings['OK'] = 'OK';
        $strings['Working'] = 'Patientez...';
        $strings['Login'] = 'Utilisateur';
        $strings['AdditionalInformation'] = 'Informations complémentaires';
        $strings['AllFieldsAreRequired'] = 'Tous les champs sont obligatoires';
        $strings['Optional'] = 'optionnel';
        $strings['YourProfileWasUpdated'] = 'Votre compte à été mis à jour';
        $strings['YourSettingsWereUpdated'] = 'Vos préférences ont été mises à jour';
        $strings['Register'] = 'Enregistrer';
        $strings['SecurityCode'] = 'Code de Sécurité';
        $strings['ReservationCreatedPreference'] = 'Quand je crée une réservation ou qu\'on la crée en mon nom';
        $strings['ReservationUpdatedPreference'] = 'Quand je mets à jour une réservation ou que quelqu\'un le fait en mon nom';
        $strings['ReservationApprovalPreference'] = 'Quand ma réservation en attente est approuvée';
        $strings['ReservationDeletedPreference'] = 'Quand j\'efface une réservation ou qu\'on l\'efface en mon nom';
        $strings['PreferenceSendEmail'] = 'Envoyez-moi un email';
        $strings['PreferenceNoEmail'] = 'Ne me prévenez pas';
        $strings['ReservationCreated'] = 'Votre réservation a été créée avec succès!';
        $strings['ReservationUpdated'] = 'Votre réservation a été mise à jour avec succès!!';
        $strings['ReservationRemoved'] = 'Votre réservation a été effacée!';
        $strings['ReservationRequiresApproval'] = 'Une ou plusieurs ressources réservées nécessitent une approbation. Cette réservation est donc mise en attente jusqu\'à ce qu\'elle soit approuvée';
        $strings['YourReferenceNumber'] = 'Votre numéro de référence est le %s';
        $strings['ChangeUser'] = 'Changer d\'Utilisateur';
        $strings['MoreResources'] = '+ de  Resources';
        $strings['ReservationLength'] = 'Durée de la réservation :';
        $strings['ParticipantList'] = 'Liste des participants';
        $strings['AddParticipants'] = 'Ajouter des Participants';
        $strings['InviteOthers'] = 'Autres Invités';
        $strings['AddResources'] = 'Ajouter des Ressources';
        $strings['AddAccessories'] = 'Ajouter des Accessoires';
        $strings['Accessory'] = 'Accessoire';
        $strings['QuantityRequested'] = 'Quantité Demandée';
        $strings['CreatingReservation'] = 'Création de Réservation';
        $strings['UpdatingReservation'] = 'Mise à jour de la Réservation';
        $strings['DeleteWarning'] = 'Cette action est définitive et non récupérable!';
        $strings['DeleteAccessoryWarning'] = 'Effacer cet accessoire le supprimera de toutes les réservations.';
        $strings['AddAccessory'] = 'Ajouter un Accessoire';
        $strings['AddBlackout'] = 'Ajouter une Mise Hors Service';
        $strings['AllResourcesOn'] = 'Appliquer à toutes les ressources';
        $strings['Reason'] = 'Motif';
        $strings['BlackoutShowMe'] = 'M\'afficher les réservations qui sont en conflit';
        $strings['BlackoutDeleteConflicts'] = 'Effacer les réservations en conflit';
        $strings['Filter'] = 'Filtrer';
        $strings['Between'] = 'Entre';
        $strings['CreatedBy'] = 'Créé par';
        $strings['BlackoutCreated'] = 'Mise Hors Service créée';
        $strings['BlackoutNotCreated'] = 'La Mise Hors Service n\'a pas pu être créée!';
        $strings['BlackoutConflicts'] = 'Il y a des périodes de Mises Hors Service en conflit';
        $strings['BlackoutUpdated'] = 'Mise Hors Service mise à jour';
        $strings['BlackoutNotUpdated'] = 'La Mise Hors Service n\' a pas être mise à jour';
        $strings['ReservationConflicts'] = 'Il y a des heures de réservation en conflit';
        $strings['UsersInGroup'] = 'Utilisateur(s) dans ce groupe';
        $strings['Browse'] = 'Parcourir';
        $strings['DeleteGroupWarning'] = 'Effacer ce groupe supprimera toutes les permissions de ressources associées. Les utilisateurs concernés pourraient perdre l\'acces à ces ressources.';
        $strings['WhatRolesApplyToThisGroup'] = 'Quel rôles appliquer à ce groupe?';
        $strings['WhoCanManageThisGroup'] = 'Qui gère ce groupe?';
        $strings['AddGroup'] = 'Ajouter un Groupe';
        $strings['AllQuotas'] = 'Tous les Quotas';
        $strings['QuotaReminder'] = 'Attention: les Quotas sont forcément basés sur le fuseau horaire du planning.';
        $strings['AllReservations'] = 'Toutes les Réservations';
        $strings['PendingReservations'] = 'Réservations en attente';
        $strings['Approving'] = 'Approbation en cours';
        $strings['MoveToSchedule'] = 'Déplacer sur le planning';
        $strings['DeleteResourceWarning'] = 'Effacer cette ressource supprimera les données associées, incluant';
        $strings['DeleteResourceWarningReservations'] = 'toutes les réservations passées, en cours et futures associées';
        $strings['DeleteResourceWarningPermissions'] = 'toutes les permissions attribuées';
        $strings['DeleteResourceWarningReassign'] = 'Réassignez tout ce que vous ne voulez pas perdre avant de valider';
        $strings['ScheduleLayout'] = 'Configuration (Toutes heures %s)';
        $strings['ReservableTimeSlots'] = 'Créneaux Réservables';
        $strings['BlockedTimeSlots'] = 'Créneaux Bloqués';
        $strings['ThisIsTheDefaultSchedule'] = 'Planning par défaut';
        $strings['DefaultScheduleCannotBeDeleted'] = 'Le planning par défaut ne peut pas être désactivé';
        $strings['MakeDefault'] = 'Mettre par Défaut';
        $strings['BringDown'] = 'Désactiver';
        $strings['ChangeLayout'] = 'Modifier sa configuration';
        $strings['AddSchedule'] = 'Ajouter un Planning';
        $strings['StartsOn'] = 'Commence le';
        $strings['NumberOfDaysVisible'] = 'Nombre de jours visibles';
        $strings['UseSameLayoutAs'] = 'Utilise la même configuration que';
        $strings['Format'] = 'Format';
        $strings['OptionalLabel'] = 'Libellé optionnel';
        $strings['LayoutInstructions'] = 'Saisir un créneau par ligne.  Les créneaux doivent couvrir 24 heures (de minuit à minuit)';
        $strings['AddUser'] = 'Ajouter un Utilisateur';
        $strings['UserPermissionInfo'] = 'L\'accès réel aux ressources peut parfois être different de ce qui est indiqué ici (rôle de l\'utilisateur, permissions du groupe, réglages de permissions autres)';
        $strings['DeleteUserWarning'] = 'Effacer cet utilisateur supprimera toutes ses réservations passées, actuelles et futures.';
        $strings['AddAnnouncement'] = 'Ajouter une Annonce';
        $strings['Announcement'] = 'Annonce';
        $strings['Priority'] = 'Priorité';
        $strings['Reservable'] = 'Réservable';
        $strings['Unreservable'] = 'Non Réservable';
        $strings['Reserved'] = 'Réservé';
        $strings['MyReservation'] = 'Mes Réservations';
        $strings['Pending'] = 'En attente';
        $strings['Past'] = 'Passé';
        $strings['Restricted'] = 'Restreint';
        $strings['ViewAll'] = 'Tout Voir';
        $strings['MoveResourcesAndReservations'] = 'Déplacer les ressources et réservations vers';
        $strings['TurnOffSubscription'] = 'Bloquer les inscriptions au Calendrier';
        $strings['TurnOnSubscription'] = 'Permettre les inscriptions au Calendrier';
        $strings['SubscribeToCalendar'] = 'S\'inscrire au Calendrier';
        $strings['SubscriptionsAreDisabled'] = 'L\'administrateur a bloqué les inscriptions à ce Calendrier';
        $strings['NoResourceAdministratorLabel'] = '(Pas d\'Administrateur de ressources)';
        $strings['WhoCanManageThisResource'] = 'Qui peut gérer cette ressource ?';
        $strings['ResourceAdministrator'] = 'Administrateur de la Ressource';
        $strings['Private'] = 'Privé';
        $strings['Accept'] = 'Accepter';
        $strings['Decline'] = 'Refuser';
        $strings['ShowFullWeek'] = 'Montrer la semaine entière';
        $strings['CustomAttributes'] = 'Attributs Personnalisés';
        $strings['AddAttribute'] = 'Ajouter un Attribut';
        $strings['EditAttribute'] = 'Mise à Jour d\'un Attribut';
        $strings['DisplayLabel'] = 'Libellé affiché';
        $strings['Type'] = 'Type';
        $strings['Required'] = 'Obligatoire';
        $strings['ValidationExpression'] = 'Expression de Validation ';
        $strings['PossibleValues'] = 'Valeurs possibles';
        $strings['SingleLineTextbox'] = 'Champ de texte simple';
        $strings['MultiLineTextbox'] = 'Champ de texte multiligne';
        $strings['Checkbox'] = 'Case à cocher';
        $strings['SelectList'] = 'Liste de sélection';
        $strings['CommaSeparated'] = 'Séparé par des virgules';
        $strings['Category'] = 'Catégorie';
        $strings['CategoryReservation'] = 'Réservation';
        $strings['CategoryGroup'] = 'Groupe';
        $strings['SortOrder'] = 'Tri';
        $strings['Title'] = 'Libellé';
        $strings['AdditionalAttributes'] = 'Attribut supplémentaire';
        $strings['True'] = 'Vrai';
        $strings['False'] = 'Faux';
        $strings['ForgotPasswordEmailSent'] = 'Un email a été envoyé à l\'adresse fournie avec les instructions pour reinitialiser votre mot de passe';
        $strings['ActivationEmailSent'] = 'Vous recevrez bientôt un email d\'activation.';
        $strings['AccountActivationError'] = 'Désolé, impossible d\'activer votre compte.';
        $strings['Attachments'] = 'Pièces-jointes';
        $strings['AttachFile'] = 'Joindre un fichier';
        $strings['Maximum'] = 'max';
        $strings['NoScheduleAdministratorLabel'] = 'Pas d\'administrateur de planning';
        $strings['ScheduleAdministrator'] = 'Administrateur de planning';
        $strings['Total'] = 'Total';
        $strings['QuantityReserved'] = 'Quantité Réservée';
        $strings['AllAccessories'] = 'Tous les Accessoires';
        $strings['GetReport'] = 'Obtenir un Rapport';
        $strings['NoResultsFound'] = 'Aucun résultat trouvé';
        $strings['SaveThisReport'] = 'Enregistrer ce rapport';
        $strings['ReportSaved'] = 'Rapport enregistré!';
        $strings['EmailReport'] = 'Envoyer le rapport par mail';
        $strings['ReportSent'] = 'Rapport envoyé!';
        $strings['RunReport'] = 'Lancer le rapport';
        $strings['NoSavedReports'] = 'Aucun rapport enregistré.';
        $strings['CurrentWeek'] = 'Semaine en cours';
        $strings['CurrentMonth'] = 'Mois en cours';
        $strings['AllTime'] = 'Tout';
        $strings['FilterBy'] = 'Filtré par';
        $strings['Select'] = 'Sélectionnez';
        $strings['List'] = 'Liste';
        $strings['TotalTime'] = 'Temps total';
        $strings['Count'] = 'Compte';
        $strings['Usage'] = 'Utilisation';
        $strings['AggregateBy'] = 'Grouper par';
        $strings['Range'] = 'Période';
        $strings['Choose'] = 'Choisir';
        $strings['All'] = 'Tout';
        $strings['ViewAsChart'] = 'Voir en Graphique';
        $strings['ReservedResources'] = 'Ressources Réservées';
        $strings['ReservedAccessories'] = 'Accessoires Réservés';
        $strings['ResourceUsageTimeBooked'] = 'Utilisation des Ressources - Durée des Réservations';
        $strings['ResourceUsageReservationCount'] = 'Utilisation des Ressources - Nombre de Réservations';
        $strings['Top20UsersTimeBooked'] = 'Top 20 des Utilisateurs - Durée des Réservations';
        $strings['Top20UsersReservationCount'] = 'Top 20 des Utilisateurs - Nombre de Réservations';
        $strings['ConfigurationUpdated'] = 'Le fichier de configuration a été mis à jour';
        $strings['ConfigurationUiNotEnabled'] = 'Cette page est inacessible car $conf[\'settings\'][\'pages\'][\'enable.configuration\'] est égal à false ou manquant.';
        $strings['ConfigurationFileNotWritable'] = 'Le fichier de configuration n\'est pas accessible en écriture. Veuillez vérifier les permissions de ce fichier et essayez à nouveau.';
        $strings['ConfigurationEnvWarning'] = 'Certaines valeurs de configuration sont remplacées par vos variables d\'environnement ou le fichier <code>.env</code>. Il se peut que des modifications ne soient possibles que si vous supprimez les variables d\'environnement correspondantes.';
        $strings['ConfigurationUpdateHelp'] = 'Veuillez vous référer à la section Configuration du <a target=_blank href=%s>fichier d\'aide</a> pour la documentation concernant ces paramètres.';
        $strings['GeneralConfigSettings'] = 'paramètres';
        $strings['UseSameLayoutForAllDays'] = 'Utiliser la même disposition pour tous les jours';
        $strings['LayoutVariesByDay'] = 'La disposition diffère chaque jour';
        $strings['ManageReminders'] = 'Rappels';
        $strings['ReminderUser'] = 'ID utilisateur';
        $strings['ReminderMessage'] = 'Message';
        $strings['ReminderAddress'] = 'Addresses';
        $strings['ReminderSendtime'] = 'Heure d\'envoi';
        $strings['ReminderRefNumber'] = 'Référence de la réservation';
        $strings['ReminderSendtimeDate'] = 'Date de rappel';
        $strings['ReminderSendtimeTime'] = 'Heure de rappel (HH:MM)';
        $strings['ReminderSendtimeAMPM'] = 'AM / PM';
        $strings['AddReminder'] = 'Ajouter un rappel';
        $strings['DeleteReminderWarning'] = 'Etes-vous sûr de vouloir supprimer ceci?';
        $strings['NoReminders'] = 'Vous n\'avez pas de prochain rappels';
        $strings['Reminders'] = 'Rappels';
        $strings['SendReminder'] = 'Envoyer Rappel';
        $strings['minutes'] = 'minutes';
        $strings['hours'] = 'heures';
        $strings['days'] = 'jours';
        $strings['ReminderBeforeStart'] = 'avant l\'heure de début';
        $strings['ReminderBeforeEnd'] = 'avant l\'heure de fin';
        $strings['Logo'] = 'Logo';
        $strings['CssFile'] = 'Fichier CSS';
        $strings['ThemeUploadSuccess'] = 'Vos modifications ont été sauvegardées. Rafraîchissez la page pour que les changements prennent effet.';
        $strings['MakeDefaultSchedule'] = 'Faire de cette page mon planning par défault';
        $strings['DefaultScheduleSet'] = 'Ceci est maintenant votre planning par défaut';
        $strings['FlipSchedule'] = 'Changer la disposition du planning';
        $strings['Next'] = 'Suivant';
        $strings['Success'] = 'Réussi';
        $strings['Participant'] = 'Participant';
        $strings['ResourceFilter'] = 'Filtre de Ressources';
        $strings['ResourceGroups'] = 'Groupes de la Ressource';
        $strings['AddNewGroup'] = 'Ajouter un nouveau groupe';
        $strings['Quit'] = 'Quitter';
        $strings['AddGroup'] = 'Ajouter Groupe';
        $strings['StandardScheduleDisplay'] = 'Afficher le planning standard';
        $strings['TallScheduleDisplay'] = 'Afficher le planning en mode étroit';
        $strings['WideScheduleDisplay'] = 'Afficher le planning en mode large';
        $strings['CondensedWeekScheduleDisplay'] = 'Afficher le planning de la semaine en mode compact';
        $strings['ResourceGroupHelp1'] = 'Faire un glisser/déposer pour réorganiser les groupes des ressources.';
        $strings['ResourceGroupHelp2'] = 'Faire un clic droit sur le nom d\'un groupe pour effectuer des actions supplémentaires.';
        $strings['ResourceGroupHelp3'] = 'Faire un glisser/déposer sur une ressource pour l\'ajouter à un groupe.';
        $strings['ResourceGroupWarning'] = 'Si des groupes sont utilisés pour les ressources, chaque ressource doit être associée à au moins un groupe. Les ressources non associées ne peuvent pas être réservées.';
        $strings['ResourceType'] = 'Type de Ressources';
        $strings['AppliesTo'] = 'Appliquer à';
        $strings['UniquePerInstance'] = 'Unique Par Instance';
        $strings['AddResourceType'] = 'Ajouter un Type de Ressources';
        $strings['NoResourceTypeLabel'] = '(aucun type de ressources défini)';
        $strings['ClearFilter'] = 'Supprimer le Filtre';
        $strings['MinimumCapacity'] = 'Capacité Minimale';
        $strings['Color'] = 'Couleur';
        $strings['Available'] = 'Disponible';
        $strings['Unavailable'] = 'Indisponible';
        $strings['Hidden'] = 'Caché';
        $strings['ResourceStatus'] = 'Statut Resource';
        $strings['CurrentStatus'] = 'Statut Actuel';
        $strings['AllReservationResources'] = 'Toutes les Ressources de la Réservation';
        $strings['File'] = 'Fichier';
        $strings['BulkResourceUpdate'] = 'Modifier les Ressources en Bloc';
        $strings['Unchanged'] = 'Inchangé';
        $strings['Common'] = 'Commun';
        $strings['AdminOnly'] = 'Administrateurs Seulement';
        $strings['AdvancedFilter'] = 'Filtre Avancé';
        $strings['MinimumQuantity'] = 'Quantité Minimum';
        $strings['MaximumQuantity'] = 'Quantité Maximum';
        $strings['ChangeLanguage'] = 'Changer la Langue';
        $strings['AddRule'] = 'Ajouter la Règle';
        $strings['Attribute'] = 'Attribut';
        $strings['RequiredValue'] = 'Valeur Requise';
        $strings['ReservationCustomRuleAdd'] = 'Si %s alors la couleur de la réservation sera';
        $strings['AddReservationColorRule'] = 'Ajouter une Règle de Couleur pour les Réservations';
        $strings['LimitAttributeScope'] = 'Afficher dans des Cas Spécifiques';
        $strings['CollectFor'] = 'Afficher pour';
        $strings['SignIn'] = 'Connexion';
        $strings['AllParticipants'] = 'Tous les Participants';
        $strings['RegisterANewAccount'] = 'Enregistrer un Nouveau Compte';
        $strings['Dates'] = 'Dates';
        $strings['More'] = 'Plus';
        $strings['ResourceAvailability'] = 'Disponibilité des Ressources';
        $strings['UnavailableAllDay'] = 'Indisponible toute la Journée';
        $strings['AvailableUntil'] = 'Disponible jusqu\'au';
        $strings['AvailableBeginningAt'] = 'Disponible à partir de';
        $strings['AvailableAt'] = 'Disponible à';
        $strings['AllResourceTypes'] = 'Tous les Types de Ressources';
        $strings['AllResourceStatuses'] = 'Tous les États de Ressources';
        $strings['AllowParticipantsToJoin'] = 'Autoriser Participants à Rejoindre';
        $strings['Join'] = 'Rejoindre';
        $strings['YouAreAParticipant'] = 'Vous êtes un participant à cette réservation';
        $strings['YouAreInvited'] = 'Vous êtes invité à cette réservation';
        $strings['YouCanJoinThisReservation'] = 'Vous pouvez rejoindre cette réservation';
        $strings['Import'] = 'Importer';
        $strings['GetTemplate'] = 'Obtenir Modèle';
        $strings['UserImportInstructions'] = '<ul><li>Le fichier doit être au format CSV.</li><li>Les champs Utilisateur et email sont requis.</li><li>La validité de l\'attribut ne sera pas contrôlée.</li><li>Les valeurs par défaut seront appliquées aux champs non renseignés et le mot de passe sera celui de l\'utilisateur.</li><li>Utilisez le modèle fourni comme exemple.</li></ul>';
        $strings['RowsImported'] = 'Lignes Importées';
        $strings['RowsSkipped'] = 'Lignes Ignorées';
        $strings['Columns'] = 'Colonnes';
        $strings['Reserve'] = 'Réserver';
        $strings['AllDay'] = 'Toute la Journée';
        $strings['Everyday'] = 'Tous les Jours';
        $strings['IncludingCompletedReservations'] = 'Inclure les Réservations déjà Terminées';
        $strings['NotCountingCompletedReservations'] = 'Ne pas inclure les Réservations déjà Terminées';
        $strings['RetrySkipConflicts'] = 'Ignorer les réservations en conflit';
        $strings['Retry'] = 'Essayer à nouveau';
        $strings['RemoveExistingPermissions'] = 'Retirer les autorisations existantes?';
        $strings['Continue'] = 'Continuer';
        $strings['WeNeedYourEmailAddress'] = 'Votre email est requis pour réserver';
        $strings['ResourceColor'] = 'Couleur de la Ressource';
        $strings['DateTime'] = 'Date Heure';
        $strings['AutoReleaseNotification'] = 'Libéré automatiquement dans %s minutes sans confirmation';
        $strings['RequiresCheckInNotification'] = 'Nécessite un check in/out';
        $strings['NoCheckInRequiredNotification'] = 'Ne nécessite pas de check in/out';
        $strings['RequiresApproval'] = 'Nécessite un accord';
        $strings['CheckingIn'] = 'Check In';
        $strings['CheckingOut'] = 'Check Out';
        $strings['CheckIn'] = 'Check In';
        $strings['CheckOut'] = 'Check Out';
        $strings['ReleasedIn'] = 'Libéré en';
        $strings['CheckedInSuccess'] = 'Check in réussi';
        $strings['CheckedOutSuccess'] = 'Check out réussi';
        $strings['CheckInFailed'] = 'Echec de check in';
        $strings['CheckOutFailed'] = 'Echec de check out';
        $strings['CheckInTime'] = 'Heure de Check In';
        $strings['CheckOutTime'] = 'Heure de Check Out';
        $strings['OriginalEndDate'] = 'Date de fin d\'origine';
        $strings['SpecificDates'] = 'Montres Dates Spécifiques';
        $strings['Users'] = 'Utilisateurs';
        $strings['Guest'] = 'Invité';
        $strings['ResourceDisplayPrompt'] = 'Ressource à afficher';
        $strings['Credits'] = 'Crédits';
        $strings['AvailableCredits'] = 'Credits Disponibles';
        $strings['CreditUsagePerSlot'] = 'Nécessite %s crédits per créneau (hors affluence)';
        $strings['PeakCreditUsagePerSlot'] = 'Nécessite %s crédits par créneau (affluence)';
        $strings['CreditsRule'] = 'Vous n\'avez pas suffisamment de crédits. Crédits requis: %s. Credits comptabilisés: %s';
        $strings['PeakTimes'] = 'Heures d\'affluence';
        $strings['AllYear'] = 'Toute l\'année';
        $strings['MoreOptions'] = 'Plus d\'options';
        $strings['SendAsEmail'] = 'Envoyer par Email';
        $strings['UsersInGroups'] = 'Utilisateurs dans le Groupe';
        $strings['UsersWithAccessToResources'] = 'Utilisateurs avec Accès à la Ressource';
        $strings['AnnouncementSubject'] = 'Une nouvelle annonce a été postée par %s';
        $strings['AnnouncementEmailNotice'] = 'Les utilisateurs recevront cette annonce par email';
        $strings['Day'] = 'Jour';
        $strings['NotifyWhenAvailable'] = 'Me notifier quand disponible';
        $strings['AddingToWaitlist'] = 'Rajouté à la liste d\'attente';
        $strings['WaitlistRequestAdded'] = 'Vous serez notifié si cet horaire devient disponible';
        $strings['PrintQRCode'] = 'Imprimer le code QR';
        $strings['FindATime'] = 'Trouver une Disponibilité';
        $strings['AnyResource'] = 'Toutes les Ressources';
        $strings['ThisWeek'] = 'Cette Semaine';
        $strings['Hours'] = 'Heures';
        $strings['Minutes'] = 'Minutes';
        $strings['ImportICS'] = 'Importer depuis ICS';
        $strings['ImportQuartzy'] = 'Importer depuis Quartzy';
        $strings['OnlyIcs'] = 'Seuls les fichiers *.ics peuvent être chargés.';
        $strings['IcsLocationsAsResources'] = 'Les lieux seront importés en tant que ressources.';
        $strings['IcsMissingOrganizer'] = 'Tout évènement sans organisateur appartiendra à l\'utilisateur actuel.';
        $strings['IcsWarning'] = 'Les règles de réservation ne seront pas appliquées - conflits, doublons, etc non permis.';
        $strings['BlackoutAroundConflicts'] = 'Mettre hors service autour des réservations qui sont en conflit';
        $strings['DuplicateReservation'] = 'Dupliquer';
        $strings['UnavailableNow'] = 'Actuellement indisponible';
        $strings['ReserveLater'] = 'Reserver plus tard';
        $strings['CollectedFor'] = 'Associé à';
        $strings['IncludeDeleted'] = 'Inclure les Réservations Supprimées';
        $strings['Deleted'] = 'Supprimé';
        $strings['Back'] = 'Précédent';
        $strings['Forward'] = 'Suivant';
        $strings['DateRange'] = 'Intervalle de Temps';
        $strings['Copy'] = 'Copier';
        $strings['Detect'] = 'Detecter';
        $strings['Autofill'] = 'Remplir automatiquement';
        $strings['NameOrEmail'] = 'nom ou email';
        $strings['ImportResources'] = 'Importer Ressources';
        $strings['ExportResources'] = 'Exporter Ressources';
        $strings['ResourceImportInstructions'] = '<ul><li>Le fichier doit être au format CSV avec un encodage UTF-8.</li><li>Le nom est un champ obligatoire. Les champs non remplis auront des valeurs par défaut.</li><li>Les options de Statut sont \'Disponible\', \'Undisponible\' et \'Masqué\'.</li><li>Le code couleur devrait être une valeur hex. ex) #ffffff.</li><li>Les colonnes Auto-affectation et validation peuvent prendre les valeur vrai ou faux.</li><li>La validation des attributs ne sera pas appliquée.</li><li>La virgule sépare les groupes de ressources.</li><li>Les durées peuvent être saisies au format #d#h#m ou HH:mm (1d3h30m ou 27:30 pour 1 jour, 3 heures, 30 minutes)</li><li>Utiliser le modèle fourni comme exemple.</li></ul>';
        $strings['ReservationImportInstructions'] = '<ul><li>Le fichier doit être au format CSV avec un encodage UTF-8.</li><li>Les champs email, noms de ressources, début et fin sont obligatoires.</li><li>Début et fin requèrent une date complète. Le format recommandé est AAAA-mm-jj HH:mm (2017-12-31 20:30).</li><li>Les règles, conflits, et périodes de temps valides ne seront pas vérifiés.</li><li>Les notifications ne seront pas envoyées.</li><li>La validation des attributs ne sera pas appliquée.</li><li>La virgule sépare les groupes de ressources.</li><li>Utiliser le modèle fourni comme exemple.</li></ul>';
        $strings['AutoReleaseMinutes'] = 'Autorelease Minutes';
        $strings['CreditsPeak'] = 'Crédits (affluence)';
        $strings['CreditsOffPeak'] = 'Crédits (hors affluence)';
        $strings['ResourceMinLengthCsv'] = 'Durée Minimum de Réservation';
        $strings['ResourceMaxLengthCsv'] = 'Durée Maximum de Réservation';
        $strings['ResourceBufferTimeCsv'] = 'Buffer Time';
        $strings['ResourceMinNoticeAddCsv'] = 'Reservation Add Minimum Notice';
        $strings['ResourceMinNoticeUpdateCsv'] = 'Reservation Update Minimum Notice';
        $strings['ResourceMinNoticeDeleteCsv'] = 'Reservation Delete Minimum Notice';
        $strings['ResourceMaxNoticeCsv'] = 'Fin de Réservation Maximum';
        $strings['Export'] = 'Exporter';
        $strings['DeleteMultipleUserWarning'] = 'La suppression de ces utilisateurs entraînera la suppression  de toutes leurs réservations présentes, futures et passées. Aucun email ne sera envoyé.';
        $strings['DeleteMultipleReservationsWarning'] = 'Aucun emailne sera envoyé.';
        $strings['ErrorMovingReservation'] = 'Erreur de déplacement de Réservation';
        $strings['SelectUser'] = 'Selectionner Utilisateur';
        $strings['InviteUsers'] = 'Inviter Utilisateurs';
        $strings['InviteUsersLabel'] = 'Saisir les addresses email des invités';
        $strings['ApplyToCurrentUsers'] = 'Appliquer aux utilisateurs actuels';
        $strings['ReasonText'] = 'Texte Motif';
        $strings['NoAvailableMatchingTimes'] = 'Il n\'y a pas d\'heures disponibles satisfaisant votre recherche';
        $strings['Schedules'] = 'Plannings';
        $strings['NotifyUser'] = 'Notifer Utilisateur';
        $strings['UpdateUsersOnImport'] = 'Mettre à jour l\'utilisateur si l\'email existe déjà';
        $strings['UpdateResourcesOnImport'] = 'Mettre à jour les ressources actuelles si le nom existe déjà';
        $strings['Reject'] = 'Rejeter';
        $strings['CheckingAvailability'] = 'En train de vérifier la disponibilité';
        $strings['CreditPurchaseNotEnabled'] = 'Vous n\'avez pas activé la possibilité d\'acheter des crédits';
        $strings['CreditsEachCost1'] = 'Chaque';
        $strings['CreditsEachCost2'] = 'Coût de credit(s)';
        $strings['CreditsCount'] = 'Nombre de credits';
        $strings['CreditsCost'] = 'Coût';
        $strings['Currency'] = 'Devise';
        $strings['PayPalClientId'] = 'ID Client';
        $strings['PayPalSecret'] = 'Secret';
        $strings['PayPalEnvironment'] = 'Environnement';
        $strings['Sandbox'] = 'Bac à sable';
        $strings['Live'] = 'Live';
        $strings['StripePublishableKey'] = 'Clef Publiable';
        $strings['StripeSecretKey'] = 'Clef Secrète';
        $strings['CreditsUpdated'] = 'Le coût du crédit a été mis à jour';
        $strings['GatewaysUpdated'] = 'Les passerelles de paiement ont été mises-à-jour';
        $strings['PurchaseSummary'] = 'Résumé des Achats';
        $strings['EachCreditCosts'] = 'Chaque credit coûte';
        $strings['Checkout'] = 'Checkout';
        $strings['Quantity'] = 'Quantité';
        $strings['CreditPurchase'] = 'Achat de Crédit';
        $strings['EmptyCart'] = 'Votre charriot est vide.';
        $strings['BuyCredits'] = 'Acheter des Crédits';
        $strings['CreditsPurchased'] = 'credits achetés.';
        $strings['ViewYourCredits'] = 'Voir vos crédits';
        $strings['TryAgain'] = 'Essayer à nouveau';
        $strings['PurchaseFailed'] = 'Nous avons eu un probème lors du traitement de votre paiement.';
        $strings['NoteCreditsPurchased'] = 'Crédits achetés';
        $strings['CreditsUpdatedLog'] = 'Crédits achetés par %s';
        $strings['ReservationCreatedLog'] = 'Réservation créée. Numéro de reference %s';
        $strings['ReservationUpdatedLog'] = 'Réservation modifiée. Numéro de reference %s';
        $strings['ReservationDeletedLog'] = 'Réservation supprimée. Numéro de reference %s';
        $strings['BuyMoreCredits'] = 'Acheter Davantage de Crédits';
        $strings['Transactions'] = 'Transactions';
        $strings['Cost'] = 'Coût';
        $strings['PaymentGateways'] = 'Passerelles de Paiement';
        $strings['CreditHistory'] = 'Historique de Crédits';
        $strings['TransactionHistory'] = 'Historique des Transactions';
        $strings['Date'] = 'Date';
        $strings['Note'] = 'Note';
        $strings['CreditsBefore'] = 'Credits Avant';
        $strings['CreditsAfter'] = 'Credits Après';
        $strings['TransactionFee'] = 'Frais de Transaction';
        $strings['InvoiceNumber'] = 'Numéro de Facture';
        $strings['TransactionId'] = 'ID Transaction';
        $strings['Gateway'] = 'Passerelle';
        $strings['GatewayTransactionDate'] = 'Date de Transaction Passerelle';
        $strings['Refund'] = 'Remboursement';
        $strings['IssueRefund'] = 'Emettre un Remboursement';
        $strings['RefundIssued'] = 'Remboursment émis avec succès';
        $strings['RefundAmount'] = 'Montant du Remboursement';
        $strings['AmountRefunded'] = 'Remboursé';
        $strings['FullyRefunded'] = 'Complètement remboursé';
        $strings['YourCredits'] = 'Vos Crédits';
        $strings['PayWithCard'] = 'Payer par Carte';
        $strings['or'] = 'ou';
        $strings['CreditsRequired'] = 'Crédits Requis';
        $strings['AddToGoogleCalendar'] = 'Ajouter à Google';
        $strings['Image'] = 'Image';
        $strings['ChooseOrDropFile'] = 'Choosir un fichier ou tirer le ici';
        $strings['SlackBookResource'] = 'Réserver %s maintenant';
        $strings['SlackBookNow'] = 'Réserver Maintenant';
        $strings['SlackNotFound'] = 'Nous n\'avons pas trouvé de ressources avec ce nom. Réservez maintenant pour démarrer une nouvelle réservation.';
        $strings['AutomaticallyAddToGroup'] = 'Ajouter automatiquement de nouveaux utilisateurs à ce groupe';
        $strings['GroupAutomaticallyAdd'] = 'Ajout Automatique';
        $strings['TermsOfService'] = 'Termes du Service';
        $strings['EnterTermsManually'] = 'Saisir Manuellement les Termes';
        $strings['LinkToTerms'] = 'Lien Vers les Termes';
        $strings['UploadTerms'] = 'Télécharger les Termes';
        $strings['RequireTermsOfServiceAcknowledgement'] = 'Requérir l\'acceptation des Termes du Service';
        $strings['UponReservation'] = 'A la Reservation';
        $strings['UponRegistration'] = 'A l\'Enregistrement';
        $strings['ViewTerms'] = 'Voir les Termes du Service';
        $strings['IAccept'] = 'J\'Accepte';
        $strings['TheTermsOfService'] = 'les Termes du Service';
        $strings['DisplayPage'] = 'Afficher la Page';
        $strings['AvailableAllYear'] = 'Toute l\'année';
        $strings['Availability'] = 'Disponibilité';
        $strings['AvailableBetween'] = 'Disponible Entre';
        $strings['ConcurrentYes'] = 'Les ressources peuvent être réservées par plusieurs personnes simultanément';
        $strings['ConcurrentNo'] = 'Les ressources ne peuvent pas être réservées par plusieurs personnes simultanément';
        $strings['ScheduleAvailabilityEarly'] = ' Ce planning n\'est pas encore disponible. Il est disponible';
        $strings['ScheduleAvailabilityLate'] = 'Ce planning n\'est plus disponible. Il était disponible';
        $strings['ResourceImages'] = 'Images de la Ressource';
        $strings['FullAccess'] = 'Access Complet';
        $strings['ViewOnly'] = 'Voir Uniquement';
        $strings['Purge'] = 'Purger';
        $strings['UsersWillBeDeleted'] = 'utilisateurs seront supprimés';
        $strings['BlackoutsWillBeDeleted'] = 'heures d\'indisponibilités seront supprimées';
        $strings['ReservationsWillBePurged'] = 'réservations seront purgées';
        $strings['ReservationsWillBeDeleted'] = 'réservations seront supprimées';
        $strings['PermanentlyDeleteUsers'] = 'Supprime définitivement les utilisateurs qui ne sont pas connectés depuis le';
        $strings['DeleteBlackoutsBefore'] = 'Supprime les heures d\'indisponibilité antérieures au';
        $strings['DeletedReservations'] = 'Réservations Supprimées';
        $strings['DeleteReservationsBefore'] = 'Supprimer les réservations antérieures au';
        $strings['SwitchToACustomLayout'] = 'Changer vers une dispositition personalisée';
        $strings['SwitchToAStandardLayout'] = 'Changer vers une disposition standard';
        $strings['ThisScheduleUsesACustomLayout'] = 'Ce planning utilise une disposition personalisée';
        $strings['ThisScheduleUsesAStandardLayout'] = 'Ce planning utilise une disposition standard';
        $strings['SwitchLayoutWarning'] = 'Etes-vous sûr de vouloir changer le type de disposition? Ceci supprimera tous les créneaux existants.';
        $strings['DeleteThisTimeSlot'] = 'Supprimer ce créneau horaire?';
        $strings['Refresh'] = 'Rafraîchir';
        $strings['ViewReservation'] = 'Voir Réservation';
        $strings['PublicId'] = 'Id Publique';
        $strings['Public'] = 'Publique';
        $strings['AtomFeedTitle'] = '%s Réservations';
        $strings['DefaultStyle'] = 'Style par Défaut';
        $strings['Standard'] = 'Standard';
        $strings['Wide'] = 'Large';
        $strings['Tall'] = 'Long';
        $strings['EmailTemplate'] = 'Modèle d\'Email';
        $strings['SelectEmailTemplate'] = 'Selectionner un Modèle d\'Email';
        $strings['ReloadOriginalContents'] = 'Recharger le Contenu Initial';
        $strings['UpdateEmailTemplateSuccess'] = 'Modèle d\'email mis à jour';
        $strings['UpdateEmailTemplateFailure'] = 'Mise à jour de modèle d\'email impossible. Vérifier que le dossier est accessible en écriture.';
        $strings['BulkResourceDelete'] = 'Suppression en masse de Ressources';
        $strings['NewVersion'] = 'Nouvelle version!';
        $strings['WhatsNew'] = 'Quelles Nouveautés?';
        $strings['OnlyViewedCalendar'] = 'Ce planning est visible uniquement au travers de la vue calendrier';
        $strings['Grid'] = 'Grille';
        $strings['List'] = 'Liste';
        $strings['NoReservationsFound'] = 'Aucune Réservation trouvée';
        $strings['EmailReservation'] = 'Email Réservation';
        $strings['AdHocMeeting'] = 'Meeting Impromptu';
        $strings['NextReservation'] = 'Réservation Suivante';
        $strings['MissedCheckin'] = 'Check-in Raté';
        $strings['MissedCheckout'] = 'Check-out Raté';
        $strings['Utilization'] = 'Utilisation';
        $strings['SpecificTime'] = 'Heure Spécifique';
        $strings['ReservationSeriesEndingPreference'] = 'quand ma série de réservations récurrentes s\'achève';
        $strings['NotAttending'] = 'Ne participe pas';
        $strings['ViewAvailability'] = 'Voir Disponibilité';
        $strings['ReservationDetails'] = 'Détails Réservation';
        $strings['StartTime'] = 'Heure de Début';
        $strings['EndTime'] = 'Heure de Fin';
        $strings['New'] = 'Nouveau';
        $strings['Updated'] = 'Mis à jour';
        $strings['Custom'] = 'Personalisé';
        $strings['AddDate'] = 'Ajouter Date';
        $strings['RepeatOn'] = 'Répéter Le';
        $strings['ScheduleConcurrentMaximum'] = 'Un total de <b>%s</b> ressources peuvent être réservées simultanément';
        $strings['ScheduleConcurrentMaximumNone'] = 'Il n\'y a pas de limite au nombre de réservations simultanées de ressources';
        $strings['ScheduleMaximumConcurrent'] = 'Nombre maximum de réservations simultanées de ressources';
        $strings['ScheduleMaximumConcurrentNote'] = 'When set, the total number of resources that can be reserved concurrently for this schedule will be limited.';
        $strings['ScheduleResourcesPerReservationMaximum'] = 'Chaque réservation est limités à un maximum de <b>%s</b> ressources';
        $strings['ScheduleResourcesPerReservationNone'] = 'Il n\'y a pas de limite au nombre de ressources par réservation';
        $strings['ScheduleResourcesPerReservation'] = 'Nombre maximum de ressources par réservation';
        $strings['ResourceConcurrentReservations'] = 'Autoriser %s réservations simultanées';
        $strings['ResourceConcurrentReservationsNone'] = 'Ne pas autoriser de réservations simultanées';
        $strings['AllowConcurrentReservations'] = 'Autoriser des réservations simultanées';
        $strings['ResourceDisplayInstructions'] = 'Aucune ressource sélectionnée. Vous pouvez trouver l\'URL pour afficher la ressource in Gestion de l\'Application, Ressources. La ressource doit être en accés publique.';
        $strings['Owner'] = 'Propriétaire';
        $strings['MaximumConcurrentReservations'] = 'Nombre Maximum de Réservations Simultanées';
        $strings['NotifyUsers'] = 'Notifier les Utilisateurs';
        $strings['Message'] = 'Message';
        $strings['AllUsersWhoHaveAReservationInTheNext'] = 'Toute personne ayant une réservation dans le prochain';
        $strings['ChangeResourceStatus'] = 'Changer Statut de la Ressource';
        $strings['UpdateGroupsOnImport'] = 'Mettre à jour le groupe existant si le nom correspond';
        $strings['GroupsImportInstructions'] = '<ul><li>Le fichier doit être au format CSV.</li><li>Le nom est requis.</li><li>Les listes de membre devraient être des listes de emails séparés par des virgules.</li><li>Une liste vide de membres laissera la liste des membres inchangée.</li><li>Les listes d\'autorisation devraient être des listes de ressources séparées par des virgules.</li><li>Une liste vide d\'autorisations laissera les autorisations inchangées.</li><li>Utiliser le modèle fourni comme exemple.</li></ul>';
        $strings['PhoneRequired'] = 'Le téléphone est requis';
        $strings['OrganizationRequired'] = 'L\'organisation est requise';
        $strings['PositionRequired'] = 'La position est requise';
        $strings['GroupMembership'] = 'Membres du Groupe';
        $strings['AvailableGroups'] = 'Groupes Disponibles';
        $strings['CheckingAvailabilityError'] = 'Ne peut obtenir la disponibilité de la ressource - trop de ressources';
        // End Strings

        // Install
        $strings['InstallApplication'] = 'Installer LibreBooking (seulement avec MySQL)';
        $strings['IncorrectInstallPassword'] = 'Désolé, ce mot de passe est incorrect.';
        $strings['SetInstallPassword'] = 'Vous devez définir un mot de passe pour votre installation avant de pouvoir poursuivre votre installation.';
        $strings['InstallPasswordInstructions'] = 'Dans %s veuillez définir %s avec un mot de passe qui est aléatoire et difficile à trouver, ensuite retournez à cette page.<br/>Vous pouvez utiliser %s';
        $strings['NoUpgradeNeeded'] = 'LibreBooking est à jour. Aucune mise à jour n\'est nécessaire.';
        $strings['ProvideInstallPassword'] = 'Veuillez entrer le mot de passe de votre installation.';
        $strings['InstallPasswordLocation'] = 'Il se trouve dans %s sous %s.';
        $strings['VerifyInstallSettings'] = 'Veuillez vérifier les paramètres par défaut suivants avant de continuer. Vous pouvez les modifier dans %s.';
        $strings['DatabaseName'] = 'Nom de la base de données';
        $strings['DatabaseUser'] = 'Nom d\'utilisateur de la base';
        $strings['DatabaseHost'] = 'Nom d\'hôte de la base';
        $strings['DatabaseCredentials'] = 'Veuillez fournir l\'identifiant d\'un utilisateur MySQL qui a les privilèges pour créer des bases de données. Si vous n\'en connaissez pas, veuillez contacter votre administrateur de bases de données. Dans la plupart des cas, le compte \'root\' devrait fonctionner.';
        $strings['MySQLUser'] = 'Nom d\'utilisateur MySQL';
        $strings['InstallOptionsWarning'] = 'Les options suivantes ne fonctionnent probablement pas dans un environnement hébergé. Dans ce cas, veuillez utiliser l\'assistant MySQL pour effectuer ces étapes.';
        $strings['CreateDatabase'] = 'Créer la base de données';
        $strings['CreateDatabaseUser'] = 'Créer le compte utilisateur de la base';
        $strings['PopulateExampleData'] = 'Importer des exemples de données. Cela va créer le compte administrateur: admin/password et le compte utilisateur: user/password';
        $strings['DataWipeWarning'] = 'Attention: cela va effacer toutes les données existantes';
        $strings['RunInstallation'] = 'Effectuer l\'installation';
        $strings['UpgradeNotice'] = 'Vous effectuez une mise à jour de la version <b>%s</b> vers la version <b>%s</b>';
        $strings['RunUpgrade'] = 'Effectuer la mise à jour';
        $strings['Executing'] = 'En cours d\'exécution';
        $strings['StatementFailed'] = 'Echec. Détails:';
        $strings['SQLStatement'] = 'Commande SQL:';
        $strings['ErrorCode'] = 'Code d\'erreur:';
        $strings['ErrorText'] = 'Texte d\'erreur:';
        $strings['InstallationSuccess'] = 'L\'installation s\'est achevée avec succès!';
        $strings['RegisterAdminUser'] = 'Enregistrer votre compte administrateur. Ceci est obligatoire si vous n\'avez pas importé les exemples de données. Vérifiez que $conf[\'settings\'][\'allow.self.registration\'] = \'true\' dans votre fichier %s.';
        $strings['LoginWithSampleAccounts'] = 'Si vous avez importé les exemples de données, vous pouvez vous connecter avec admin/password pour être administrateur ou avec user/password pour un simple compte utilisateur.';
        $strings['InstalledVersion'] = 'Vous utilisez à présent la version %s de LibreBooking';
        $strings['InstallUpgradeConfig'] = 'Il est recommandé de mettre à jour votre fichier de configuration';
        $strings['InstallationFailure'] = 'Il y a des problèmes avec l\'installation. Veuillez les corriger et réessayer.';
        $strings['ConfigureApplication'] = 'Configurer LibreBooking';
        $strings['ConfigUpdateSuccess'] = 'Votre fichier de configuration est maintenant à jour!';
        $strings['ConfigUpdateFailure'] = 'Nous n\'avons pas pu mettre à jour votre fichier de configuration automatiquement. Veuillez modifier le contenu de votre fichier config.php avec les données suivantes:';
        $strings['ScriptUrlWarning'] = 'Votre paramètre <em>script.url</em> est pet-être incorrect. Il est égal à <strong>%s</strong>, mais nous pensons qu\'il devrait être égal à <strong>%s</strong>';
        // End Install

        // Errors
        $strings['LoginError'] = 'Nom d\'utilisateur ou mot de passe inconnu';
        $strings['ReservationFailed'] = 'Votre réservation ne peut être créée';
        $strings['MinNoticeError'] = 'Cette réservation possède une contrainte de délai.  Vous pourrez réserver au plus tôt le %s.';
        $strings['MinNoticeErrorUpdate'] = 'Modifier cette réservation requière une notification préalable. Les réservations antérieures à %s ne peuvent être modifiées.';
        $strings['MinNoticeErrorDelete'] = 'Supprimer cette réservation requière une notification préalable. Les réservations antérieures à %s ne peuvent être supprimées';
        $strings['MaxNoticeError'] = 'Cette réservation ne peut être créée à une date si éloignée.  Il est possible de réserver jusqu\'au %s.';
        $strings['MinDurationError'] = 'Cette réservation doit durer au minimum %s.';
        $strings['MaxDurationError'] = 'Cette réservation ne peut durer plus de %s.';
        $strings['ConflictingAccessoryDates'] = 'Il n\'y a pas assez d\'accessoires suivants:';
        $strings['NoResourcePermission'] = 'Vous n\'avez pas la permission d\'accéder à une ou plusieurs des ressources demandées';
        $strings['ConflictingReservationDates'] = 'Il y a des réservations en conflit à la date suivante:';
        $strings['InstancesOverlapRule'] = 'Plusieurs instances de la réservation se chevauchent:';
        $strings['StartDateBeforeEndDateRule'] = 'La date de départ doit être avant la date de fin';
        $strings['StartIsInPast'] = 'La date de départ ne peut être passée';
        $strings['EmailDisabled'] = 'L\'administrateur a désactivé les notifications par email.';
        $strings['ValidLayoutRequired'] = 'Les créneaux doivent couvrir 24 heures (de minuit à minuit).';
        $strings['CustomAttributeErrors'] = 'Il y a un problème avec l\'attribut supplémentaire que vous avez ajouté :';
        $strings['CustomAttributeRequired'] = '%s est un champ obligatoire';
        $strings['CustomAttributeInvalid'] = 'La valeur saisie pour %s est invalide';
        $strings['AttachmentLoadingError'] = 'Désolé, il y a eu un problème de chargement du fichier demandé.';
        $strings['InvalidAttachmentExtension'] = 'Vous pouvez uniquement uploader des fichiers de type : %s';
        $strings['InvalidStartSlot'] = 'La date et heure de début demandée n\'est pas valide.';
        $strings['InvalidEndSlot'] = 'La date et heure de fin demandée n\'est pas valide.';
        $strings['MaxParticipantsError'] = '%s ne supporte que %s participants.';
        $strings['ReservationCriticalError'] = 'Une erreur critique s\'est produite lors de la sauvegarde de la réservation. Si cela persiste, contactez votre administrateur système.';
        $strings['InvalidStartReminderTime'] = 'L\'heure de début du rappel n\'est pas valide.';
        $strings['InvalidEndReminderTime'] = 'L\'heure de fin du rappel n\'est pas valide.';
        $strings['QuotaExceeded'] = 'Limite de quota dépassée.';
        $strings['MultiDayRule'] = '%s ne permet pas de réservations sur plusieurs jours.';
        $strings['InvalidReservationData'] = 'Votre demande de réservation a rencontré des problèmes.';
        $strings['PasswordError'] = 'Le mot de passe doit contenir au moins %s lettres et au moins %s chiffres.';
        $strings['PasswordErrorRequirements'] = 'Le mot de passe doit contenir au moins %s lettres majuscules et minuscules et %s chiffres.';
        $strings['NoReservationAccess'] = 'Vous n\'êtes pas autorisé à changer cette réservation.';
        $strings['PasswordControlledExternallyError'] = 'Votre mot de passe est contrôlé par un système externe et ne peut pas être mis à jour ici.';
        $strings['AccessoryResourceRequiredErrorMessage'] = 'L\'Accessoire %s peut être réservé uniquement avec la ressource %s';
        $strings['AccessoryMinQuantityErrorMessage'] = 'Vous devez réserver au-moins %s accessoires %s';
        $strings['AccessoryMaxQuantityErrorMessage'] = 'Vous ne pouvez réserver plus que %s accessoires %s';
        $strings['AccessoryResourceAssociationErrorMessage'] = 'L\'accessoire \'%s\' ne peut être réservé avec les ressources demandées';
        $strings['NoResources'] = 'Vous n\'avez ajouté aucune ressource.';
        $strings['ParticipationNotAllowed'] = 'Vous n\'êtes pas autorisé à vous joindre à cette réservation.';
        $strings['ReservationCannotBeCheckedInTo'] = 'Vous ne pouvez pas effectuer un check-in avec cette réservation.';
        $strings['ReservationCannotBeCheckedOutFrom'] = 'Vous ne pouvez pas effectuer un check-out avec cette réservation.';
        $strings['InvalidEmailDomain'] = 'L\'adresse email n\'appartient pas à un domaine autorisé';
        $strings['TermsOfServiceError'] = 'Vous devez accepter les Termes du Service';
        $strings['UserNotFound'] = 'Utilisateur non trouvé';
        $strings['ScheduleAvailabilityError'] = 'Ce planning est disponible entre %s et %s';
        $strings['ReservationNotFoundError'] = 'Réservation non trouvée';
        $strings['ReservationNotAvailable'] = 'Réservation non disponible';
        $strings['TitleRequiredRule'] = 'Le libellé de la réservation est requis';
        $strings['DescriptionRequiredRule'] = 'La description de la réservation est requise';
        $strings['WhatCanThisGroupManage'] = 'Que peut gérer ce groupe?';
        $strings['ReservationParticipationActivityPreference'] = 'quand quelqu\'un rejoint ou quitte ma réservation';
        $strings['RegisteredAccountRequired'] = 'Seuls les utilisateurs enregistrés peuvent effectuer des réservations';
        $strings['InvalidNumberOfResourcesError'] = 'Le nombre maximum de ressources qui peuvent être allouées dans une réservation est %s';
        $strings['ScheduleTotalReservationsError'] = 'Ce planning autorise uniquement %s resources simultanées. Cette réservation violerait cette limite aux dates suivantes:';
        // End Errors

        // Page Titles
        $strings['CreateReservation'] = 'Créer une Réservation';
        $strings['EditReservation'] = 'Editer une Réservation';
        $strings['LogIn'] = 'Connexion';
        $strings['ManageReservations'] = 'Réservations';
        $strings['AwaitingActivation'] = 'En attente d\'Activation';
        $strings['PendingApproval'] = 'En attente d\'Approbation';
        $strings['ManageSchedules'] = 'Plannings';
        $strings['ManageResources'] = 'Ressources';
        $strings['ManageAccessories'] = 'Accessoires';
        $strings['ManageUsers'] = 'Utilisateurs';
        $strings['ManageGroups'] = 'Groupes';
        $strings['ManageQuotas'] = 'Quotas';
        $strings['ManageBlackouts'] = 'Périodes de Mise Hors Service';
        $strings['MyDashboard'] = 'Mon tableau de bord';
        $strings['ServerSettings'] = 'Préférences du Serveur';
        $strings['Dashboard'] = 'Tableau de Bord';
        $strings['Help'] = 'Aide';
        $strings['Administration'] = 'Administration';
        $strings['About'] = 'À propos';
        $strings['Bookings'] = 'Réservations';
        $strings['Schedule'] = 'Planning';
        $strings['Account'] = 'Compte';
        $strings['EditProfile'] = 'Editer Mon Profil';
        $strings['FindAnOpening'] = 'Trouver une invitation';
        $strings['OpenInvitations'] = 'Invitations';
        $strings['ResourceCalendar'] = 'Calendrier des Ressources';
        $strings['Reservation'] = 'Nouvelle Réservation';
        $strings['Install'] = 'Installation';
        $strings['ChangePassword'] = 'Modifier le Mot de Passe';
        $strings['MyAccount'] = 'Mon Compte';
        $strings['Profile'] = 'Profil';
        $strings['ApplicationManagement'] = 'Gestion de l\'Application';
        $strings['ForgotPassword'] = 'Mot de Passe perdu';
        $strings['NotificationPreferences'] = 'Préférences de Messagerie';
        $strings['ManageAnnouncements'] = 'Annonces';
        $strings['Responsibilities'] = 'Responsables';
        $strings['GroupReservations'] = 'Réservations de Groupe';
        $strings['ResourceReservations'] = 'Réservations de Ressource ';
        $strings['Customization'] = 'Personnalisation';
        $strings['Attributes'] = 'Attributs';
        $strings['AccountActivation'] = 'Activation de compte';
        $strings['ScheduleReservations'] = 'Réservations du Planning';
        $strings['Reports'] = 'Rapports';
        $strings['GenerateReport'] = 'Nouveau Rapport';
        $strings['MySavedReports'] = 'Rapports Sauvegardés';
        $strings['CommonReports'] = 'Rapports Standards';
        $strings['ViewDay'] = 'Vue/Jour';
        $strings['Group'] = 'Groupe';
        $strings['ManageConfiguration'] = 'Configuration de l\'Application';
        $strings['LookAndFeel'] = 'Apparence';
        $strings['ManageResourceGroups'] = 'Groupes de la Ressource';
        $strings['ManageResourceTypes'] = 'Types de Ressources';
        $strings['ManageResourceStatus'] = 'États des Ressources';
        $strings['ReservationColors'] = 'Couleurs des Réservations';
        $strings['SearchReservations'] = 'Rechercher des Réservations';
        $strings['ManagePayments'] = 'Paiements';
        $strings['ViewCalendar'] = 'Voir le Calendrier';
        $strings['DataCleanup'] = 'Nettoyage des données';
        $strings['ManageEmailTemplates'] = 'Gérer les Modèles de Email';
        // End Page Titles

        // Day representations
        $strings['DaySundaySingle'] = 'D';
        $strings['DayMondaySingle'] = 'L';
        $strings['DayTuesdaySingle'] = 'M';
        $strings['DayWednesdaySingle'] = 'M';
        $strings['DayThursdaySingle'] = 'J';
        $strings['DayFridaySingle'] = 'V';
        $strings['DaySaturdaySingle'] = 'S';

        $strings['DaySundayAbbr'] = 'Dim';
        $strings['DayMondayAbbr'] = 'Lun';
        $strings['DayTuesdayAbbr'] = 'Mar';
        $strings['DayWednesdayAbbr'] = 'Mer';
        $strings['DayThursdayAbbr'] = 'Jeu';
        $strings['DayFridayAbbr'] = 'Ven';
        $strings['DaySaturdayAbbr'] = 'Sam';
        // End Day representations

        // Email Subjects
        $strings['ReservationApprovedSubject'] = 'Votre réservation a été approuvée';
        $strings['ReservationCreatedSubject'] = 'Votre réservation a été créée';
        $strings['ReservationUpdatedSubject'] = 'Votre réservation a été mise à jour';
        $strings['ReservationDeletedSubject'] = 'Votre réservation a été effacée';
        $strings['ReservationCreatedAdminSubject'] = 'Notification: Une réservation a été créée';
        $strings['ReservationUpdatedAdminSubject'] = 'Notification: Une réservation a été mise à jour';
        $strings['ReservationDeleteAdminSubject'] = 'Notification: Une réservation a été effacée';
        $strings['ParticipantAddedSubject'] = 'Notication de Participation à une Réservation';
        $strings['ParticipantDeletedSubject'] = 'Réservation Effacée';
        $strings['InviteeAddedSubject'] = 'Invitation à une Réservation';
        $strings['ResetPasswordRequest'] = 'Demande de Réinitialisation du Mot de Passe';
        $strings['ForgotPasswordEmailSent'] = 'Un email contenant les instructions pour réinitialiser votre mot de passe vous a été envoyé.';
        $strings['ActivateYourAccount'] = 'Activez votre compte SVP';
        $strings['ReportSubject'] = 'Le rapport demandé (%s)';
        $strings['ReservationStartingSoonSubject'] = 'Réservation pour %s démarrera bientôt';
        $strings['ReservationEndingSoonSubject'] = 'Réservation pour %s finira bientôt';
        $strings['UserAdded'] = 'Un nouvel utilisateur a été ajouté';
        $strings['UserDeleted'] = 'Compte utilisateur pour %s supprimé par %s';
        $strings['GuestAccountCreatedSubject'] = 'Le détail de votre compte %s';
        $strings['AccountCreatedSubject'] = 'Détail de votre compte %s';
        $strings['InviteUserSubject'] = '%s vous a invité à rejoindre %s';

        $strings['ReservationApprovedSubjectWithResource'] = 'Réservation  approuvé pour %s';
        $strings['ReservationCreatedSubjectWithResource'] = 'Réservation créée pour %s';
        $strings['ReservationUpdatedSubjectWithResource'] = 'Réservation mise à jour pour %s';
        $strings['ReservationDeletedSubjectWithResource'] = 'Réservation supprimée pour %s';
        $strings['ReservationCreatedAdminSubjectWithResource'] = 'Notification: Réservation créée pour %s';
        $strings['ReservationUpdatedAdminSubjectWithResource'] = 'Notification: Réservation mise à jour pour %s';
        $strings['ReservationDeleteAdminSubjectWithResource'] = 'Notification: Réservation supprimée pour %s';
        $strings['ReservationApprovalAdminSubjectWithResource'] = 'Notification: Réservation pour %s nécessite votre accord';
        $strings['ParticipantAddedSubjectWithResource'] = '%s vous a ajouté à la réservation pour %s';
        $strings['ParticipantUpdatedSubjectWithResource'] = '%s a mis à jour la réservation pour %s';
        $strings['ParticipantDeletedSubjectWithResource'] = '%s a supprimé la réservation pour %s';
        $strings['InviteeAddedSubjectWithResource'] = '%s vous a invité à la réservation pour %s';
        $strings['MissedCheckinEmailSubject'] = 'Check-in manquant pour %s';
        $strings['ReservationShareSubject'] = '%s a partagé une réservation pour %s';
        $strings['ReservationSeriesEndingSubject'] = 'La série de réservations pour %s se terminera le %s';
        $strings['ReservationParticipantAccept'] = '%s a accepté votre invitation à la réservation pour %s le %s';
        $strings['ReservationParticipantDecline'] = '%s a décliné votre invitation à la réservation pour %s le %s';
        $strings['ReservationParticipantJoin'] = '%s a rejoint votre réservation pour %s le %s';
        $strings['ReservationAvailableSubject'] = '%s est disponible le %s';
        $strings['ResourceStatusChangedSubject'] = 'La disponibilité de %s a changé';
        // End Email Subjects

        //NEEDS CHECKING
        //Past Reservations
        $strings['NoPastReservations'] = 'Vous n\'avez aucune réservation passée';
        $strings['PastReservations'] = 'Réservations passées';
        $strings['AllNoPastReservations'] = 'Il n\'y a aucune réservation passée au cours des %s derniers jours';
        $strings['AllPastReservations'] = 'Toutes les réservations passées';
        $strings['Yesterday'] = 'Hier';
        $strings['EarlierThisWeek'] = 'Plus tôt cette semaine';
        $strings['PreviousWeek'] = 'Semaine précédente';
        //End Past Reservations

        //Group Upcoming Reservations
        $strings['NoGroupUpcomingReservations'] = 'Votre groupe n\'a aucune réservation à venir';
        $strings['GroupUpcomingReservations'] = 'Prochaines réservations de mon/des groupes';
        //End Group Upcoming Reservations

        //Facebook Login SDK Error
        $strings['FacebookLoginErrorMessage'] = 'Une erreur est survenue lors de la connexion avec Facebook. Veuillez réessayer.';
        //End Facebook Login SDK Error

        //Pending Approval Reservations in Dashboard
        $strings['NoPendingApprovalReservations'] = 'Vous n\'avez aucune réservation en attente d\'approbation';
        $strings['PendingApprovalReservations'] = 'Réservations en attente d\'approbation';
        $strings['LaterThisMonth'] = 'Plus tard ce mois-ci';
        $strings['LaterThisYear'] = 'Plus tard cette année';
        $strings['Remaining'] = 'Restant';
        //End Pending Approval Reservations in Dashboard

        //Missing Check In/Out Reservations in Dashboard
        $strings['NoMissingCheckOutReservations'] = 'Il n\'y a pas de réservations de départ manquantes';
        $strings['MissingCheckOutReservations'] = 'Réservations de départ manquantes';
        //End Missing Check In/Out Reservations in Dashboard

        //Schedule Resource Permissions
        $strings['NoResourcePermissions'] = 'Impossible de voir les détails de la réservation car vous n\'avez pas les autorisations pour l\'un des ressources dans cette réservation';
        //End Schedule Resource Permissions
        //END NEEDS CHECKING


        $this->Strings = $strings;
        return $this->Strings;
    }

    /**
     * @return array
     */
    protected function _LoadDays()
    {
        $days = parent::_LoadDays();

        /***
         * DAY NAMES
         * All of these arrays MUST start with Sunday as the first element
         * and go through the seven day week, ending on Saturday
         ***/
        // The full day name
        $days['full'] = ['Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi'];
        // The three letter abbreviation
        $days['abbr'] = ['Dim', 'Lun', 'Mar', 'Mer', 'Jeu', 'Ven', 'Sam'];
        // The two letter abbreviation
        $days['two'] = ['Di', 'Lu', 'Ma', 'Me', 'Je', 'Ve', 'Sa'];
        // The one letter abbreviation
        $days['letter'] = ['D', 'L', 'M', 'M', 'J', 'V', 'S'];

        $this->Days = $days;
        return $this->Days;
    }

    protected function _LoadMonths()
    {
        $months = parent::_LoadMonths();

        /***
         * MONTH NAMES
         * All of these arrays MUST start with January as the first element
         * and go through the twelve months of the year, ending on December
         ***/
        // The full month name
        $months['full'] = ['Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre'];
        // The three letter month name
        $months['abbr'] = ['Jan', 'Fév', 'Mar', 'Avr', 'Mai', 'Jun', 'Jul', 'Aoû', 'Sep', 'Oct', 'Nov', 'Déc'];

        $this->Months = $months;
        return $this->Months;
    }

    protected function _LoadLetters()
    {
        $this->Letters = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];
        return $this->Letters;
    }

    protected function _GetHtmlLangCode()
    {
        return 'fr';
    }
}
